/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb1.smb1;

import jcifs.smb1.smb1.ServerMessageBlock;

class SmbComWrite
extends ServerMessageBlock {
    private int fid;
    private int count;
    private int offset;
    private int remaining;
    private int off;
    private byte[] b;

    SmbComWrite() {
        this.command = (byte)11;
    }

    SmbComWrite(int fid, int offset, int remaining, byte[] b, int off, int len) {
        this.fid = fid;
        this.count = len;
        this.offset = offset;
        this.remaining = remaining;
        this.b = b;
        this.off = off;
        this.command = (byte)11;
    }

    void setParam(int fid, long offset, int remaining, byte[] b, int off, int len) {
        this.fid = fid;
        this.offset = (int)(offset & 0xFFFFFFFFL);
        this.remaining = remaining;
        this.b = b;
        this.off = off;
        this.count = len;
        this.digest = null;
    }

    @Override
    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SmbComWrite.writeInt2(this.fid, dst, dstIndex);
        SmbComWrite.writeInt2(this.count, dst, dstIndex += 2);
        SmbComWrite.writeInt4(this.offset, dst, dstIndex += 2);
        SmbComWrite.writeInt2(this.remaining, dst, dstIndex += 4);
        return (dstIndex += 2) - start;
    }

    @Override
    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dst[dstIndex++] = 1;
        SmbComWrite.writeInt2(this.count, dst, dstIndex);
        System.arraycopy(this.b, this.off, dst, dstIndex += 2, this.count);
        return (dstIndex += this.count) - start;
    }

    @Override
    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return new String("SmbComWrite[" + super.toString() + ",fid=" + this.fid + ",count=" + this.count + ",offset=" + this.offset + ",remaining=" + this.remaining + "]");
    }
}

