/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.model;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.manip.ManipulationException;

public class Project {
    private final File pom;
    private final Model model;
    private ProjectVersionRef key;
    private boolean inheritanceRoot;
    private boolean executionRoot;

    public Project(ProjectVersionRef key, File pom, Model model) {
        this.pom = pom;
        this.model = model;
        this.key = key;
    }

    public Project(File pom, Model model) throws ManipulationException {
        this(Project.modelKey(model), pom, model);
    }

    public Project(Model model) throws ManipulationException {
        this(Project.modelKey(model), model.getPomFile(), model);
    }

    public File getPom() {
        return this.pom;
    }

    public Model getModel() {
        return this.model;
    }

    public ProjectVersionRef getKey() {
        return this.key;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        return this.key + " [pom=" + this.pom + "]";
    }

    public Parent getParent() {
        return this.model.getParent();
    }

    public String getGroupId() {
        return this.key.getGroupId();
    }

    public String getArtifactId() {
        return this.key.getArtifactId();
    }

    public String getId() {
        return this.model.getId();
    }

    public String getVersion() {
        return this.key.getVersionString();
    }

    public List<Plugin> getPlugins() {
        return this.getPlugins((ModelBase)this.model);
    }

    public List<Plugin> getPlugins(ModelBase base) {
        BuildBase build = this.getBuild(base);
        if (build == null) {
            return Collections.emptyList();
        }
        List result = build.getPlugins();
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public Map<String, Plugin> getPluginMap() {
        return this.getPluginMap((ModelBase)this.model);
    }

    public Map<String, Plugin> getPluginMap(ModelBase base) {
        Object build = base instanceof Model ? ((Model)base).getBuild() : ((Profile)base).getBuild();
        if (build == null) {
            return Collections.emptyMap();
        }
        Map result = build.getPluginsAsMap();
        if (result == null) {
            return Collections.emptyMap();
        }
        return result;
    }

    public Build getBuild() {
        return (Build)this.getBuild((ModelBase)this.model);
    }

    public BuildBase getBuild(ModelBase base) {
        Object build = base instanceof Model ? ((Model)base).getBuild() : ((Profile)base).getBuild();
        return build;
    }

    public List<Plugin> getManagedPlugins(ModelBase base) {
        Object build = base instanceof Model ? ((Model)base).getBuild() : ((Profile)base).getBuild();
        if (build == null) {
            return Collections.emptyList();
        }
        PluginManagement pm = build.getPluginManagement();
        if (pm == null) {
            return Collections.emptyList();
        }
        List result = pm.getPlugins();
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public Map<String, Plugin> getManagedPluginMap(ModelBase base) {
        if (base instanceof Model) {
            Build build = ((Model)base).getBuild();
            if (build == null) {
                return Collections.emptyMap();
            }
            PluginManagement pm = build.getPluginManagement();
            if (pm == null) {
                return Collections.emptyMap();
            }
            Map result = pm.getPluginsAsMap();
            if (result == null) {
                return Collections.emptyMap();
            }
            return result;
        }
        return Collections.emptyMap();
    }

    public Iterable<Dependency> getDependencies() {
        return this.getDependencies((ModelBase)this.model);
    }

    public Iterable<Dependency> getDependencies(ModelBase base) {
        List<Dependency> deps = base.getDependencies();
        if (deps == null) {
            deps = Collections.emptyList();
        }
        return deps;
    }

    public Iterable<Dependency> getManagedDependencies() {
        return this.getManagedDependencies((ModelBase)this.model);
    }

    public Iterable<Dependency> getManagedDependencies(ModelBase base) {
        DependencyManagement dm = base.getDependencyManagement();
        if (dm == null || dm.getDependencies() == null) {
            return Collections.emptyList();
        }
        return dm.getDependencies();
    }

    public void setInheritanceRoot(boolean inheritanceRoot) {
        this.inheritanceRoot = inheritanceRoot;
    }

    public boolean isInheritanceRoot() {
        return this.inheritanceRoot;
    }

    private static ProjectVersionRef modelKey(Model model) throws ManipulationException {
        String g = model.getGroupId();
        String v = model.getVersion();
        if (g == null || v == null) {
            Parent p = model.getParent();
            if (p == null) {
                throw new ManipulationException("Invalid model: " + model + " Cannot find groupId and/or version!", new String[0]);
            }
            if (g == null) {
                g = p.getGroupId();
            }
            if (v == null) {
                v = p.getVersion();
            }
        }
        String a = model.getArtifactId();
        return new SimpleProjectVersionRef(g, a, v);
    }

    public void setExecutionRoot() {
        this.executionRoot = true;
    }

    public boolean isExecutionRoot() {
        return this.executionRoot;
    }
}

