/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.model.view;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.commonjava.maven.galley.maven.model.view.MavenXmlView;
import org.commonjava.maven.galley.maven.parse.JXPathUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractMavenElementView<T extends MavenXmlView<?>> {
    protected final Element element;
    protected final JXPathContext elementContext;
    protected final T xmlView;

    public AbstractMavenElementView(T xmlView, Element element) {
        this.xmlView = xmlView;
        this.element = element;
        this.elementContext = JXPathUtils.newContext(element);
    }

    public final Element getElement() {
        return this.element;
    }

    public final T getXmlView() {
        return this.xmlView;
    }

    protected String getValue(String path) {
        Node node = ((MavenXmlView)this.xmlView).resolveXPathToNodeFrom(this.elementContext, path, false);
        if (node == null) {
            return null;
        }
        return node.getTextContent().trim();
    }

    protected final Element getElement(String path) {
        if (path.contains("/")) {
            return (Element)this.getNode(path);
        }
        NodeList nl = this.element.getElementsByTagName(path);
        if (nl.getLength() > 0) {
            return (Element)nl.item(0);
        }
        return null;
    }

    protected final List<Element> getElements(String path) {
        if (path.contains("/")) {
            List<Node> nodes = this.getNodes(path);
            if (nodes != null) {
                ArrayList<Element> elements = new ArrayList<Element>();
                for (Node node : nodes) {
                    elements.add((Element)node);
                }
                return elements;
            }
        } else {
            NodeList nl = this.element.getChildNodes();
            ArrayList<Element> elements = new ArrayList<Element>();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (node.getNodeType() != 1) continue;
                Element e = (Element)node;
                if (!"*".equals(path) && !e.getTagName().equals(path)) continue;
                elements.add((Element)node);
            }
            return elements;
        }
        return null;
    }

    protected final Node getNode(String path) {
        return (Node)this.elementContext.selectSingleNode(path);
    }

    protected final List<Node> getNodes(String path) {
        return this.elementContext.selectNodes(path);
    }

    public final String toXML() {
        return ((MavenXmlView)this.xmlView).toXML(this.element);
    }
}

