/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.model.view;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.AbstractMavenElementView;
import org.commonjava.maven.galley.maven.model.view.MavenPomView;
import org.commonjava.maven.galley.maven.model.view.OriginInfo;
import org.commonjava.maven.galley.maven.model.view.XmlNodeInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MavenPomElementView
extends AbstractMavenElementView<MavenPomView> {
    private final String managementXpathFragment;
    private OriginInfo originInfo;
    private String[] managementXpaths;
    private MavenPomElementView managementElement;

    public MavenPomElementView(MavenPomView pomView, Element element, OriginInfo originInfo) {
        super(pomView, element);
        this.originInfo = originInfo;
        this.managementXpathFragment = null;
    }

    public MavenPomElementView(MavenPomView pomView, Element element, OriginInfo originInfo, String managementXpathFragment) {
        super(pomView, element);
        this.originInfo = originInfo;
        this.managementXpathFragment = managementXpathFragment;
    }

    public synchronized OriginInfo getOriginInfo() {
        if (this.originInfo == null) {
            this.originInfo = new OriginInfo();
        }
        return this.originInfo;
    }

    protected String getManagedViewQualifierFragment() {
        return null;
    }

    protected boolean containsExpression(String value) {
        return ((MavenPomView)this.xmlView).containsExpression(value);
    }

    public MavenPomView getPomView() {
        return (MavenPomView)this.xmlView;
    }

    public String getProfileId() {
        return ((MavenPomView)this.xmlView).getProfileIdFor(this.element);
    }

    protected String getManagedValue(String named) throws GalleyMavenException {
        MavenPomElementView mgmt = this.getManagementElement();
        if (mgmt != null) {
            return mgmt.getValue(named);
        }
        return null;
    }

    protected String getValueWithManagement(String named) throws GalleyMavenException {
        String value = this.getValue(named);
        if (value == null) {
            return this.getManagedValue(named);
        }
        return value;
    }

    private synchronized MavenPomElementView getManagementElement() throws GalleyMavenException {
        if (this.managementElement == null) {
            this.initManagementXpaths();
            if (this.managementXpaths != null) {
                for (String xpath : this.managementXpaths) {
                    MavenPomElementView e = ((MavenPomView)this.xmlView).resolveXPathToElementView(xpath, false, -1);
                    if (e == null) continue;
                    this.managementElement = e;
                    break;
                }
            }
        }
        return this.managementElement;
    }

    protected List<XmlNodeInfo> getFirstNodesWithManagement(String path) throws GalleyMavenException {
        List<XmlNodeInfo> nodeInfos;
        block3: {
            List<Node> nodes;
            block2: {
                nodes = ((MavenPomView)this.xmlView).resolveXPathToNodeListFrom(this.elementContext, path, true);
                nodeInfos = new ArrayList<XmlNodeInfo>(nodes.size());
                if (nodes != null && !nodes.isEmpty()) break block2;
                MavenPomElementView managedElement = this.getManagementElement();
                if (managedElement == null) break block3;
                nodeInfos = managedElement.getFirstNodesWithManagement(path);
                for (XmlNodeInfo info : nodeInfos) {
                    info.setMixin(managedElement.isMixin());
                }
                break block3;
            }
            for (Node node : nodes) {
                nodeInfos.add(new XmlNodeInfo(this.isInherited(), this.isMixin(), node));
            }
        }
        return nodeInfos;
    }

    private boolean isInherited() {
        return this.originInfo == null ? false : this.originInfo.isInherited();
    }

    private boolean isMixin() {
        return this.originInfo == null ? false : this.originInfo.isMixin();
    }

    protected String getManagementXpathFragment() {
        return this.managementXpathFragment;
    }

    private void initManagementXpaths() {
        if (this.managementXpathFragment == null) {
            return;
        }
        String qualifier = this.getManagedViewQualifierFragment();
        if (qualifier == null) {
            return;
        }
        ArrayList<String> xpaths = new ArrayList<String>();
        HashSet<String> activeProfiles = new HashSet<String>(((MavenPomView)this.xmlView).getActiveProfileIds());
        activeProfiles.add(this.getProfileId());
        for (String profileId : activeProfiles) {
            if (profileId == null) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("/project/profiles/profile[id/text()=\"").append(profileId).append("\"]/").append(this.managementXpathFragment).append('[').append(qualifier).append("]");
            String xp = sb.toString();
            xpaths.add(xp);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("/project/").append(this.managementXpathFragment).append('[').append(qualifier).append("]");
        String xp = sb.toString();
        xpaths.add(xp);
        this.managementXpaths = xpaths.toArray(new String[xpaths.size()]);
    }

    @Override
    protected String getValue(String path) {
        String val = super.getValue(path);
        if (this.getProfileId() == null) {
            return ((MavenPomView)this.xmlView).resolveExpressions(val, new String[0]);
        }
        return ((MavenPomView)this.xmlView).resolveExpressions(val, this.getProfileId());
    }
}

