/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.model.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.JXPathInvalidSyntaxException;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.commonjava.maven.galley.maven.GalleyMavenRuntimeException;
import org.commonjava.maven.galley.maven.model.view.DocRef;
import org.commonjava.maven.galley.maven.model.view.MavenXmlMixin;
import org.commonjava.maven.galley.maven.model.view.XPathManager;
import org.commonjava.maven.galley.maven.parse.XMLInfrastructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MavenXmlView<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final List<DocRef<T>> stack;
    protected StringSearchInterpolator ssi;
    protected final List<MavenXmlMixin<T>> mixins = new ArrayList<MavenXmlMixin<T>>();
    protected final Set<String> localOnlyPaths;
    protected final XMLInfrastructure xml;

    public MavenXmlView(List<DocRef<T>> stack, XPathManager xpath, XMLInfrastructure xml, String ... localOnlyPaths) {
        this.stack = stack;
        this.xml = xml;
        this.localOnlyPaths = new HashSet<String>(Arrays.asList(localOnlyPaths));
    }

    public T getRef() {
        return this.stack.get(0).getRef();
    }

    public List<DocRef<T>> getDocRefStack() {
        return this.stack;
    }

    public String resolveXPathToRawString(String path, boolean cachePath, int maxDepth) throws GalleyMavenRuntimeException {
        String result = null;
        int maxAncestry = maxDepth;
        for (String pathPrefix : this.localOnlyPaths) {
            if (!path.startsWith(pathPrefix)) continue;
            maxAncestry = 0;
            break;
        }
        int ancestryDepth = 0;
        for (DocRef<T> docRef : this.stack) {
            if (maxAncestry > -1 && ancestryDepth > maxAncestry) break;
            try {
                result = (String)docRef.getDocContext().getValue(path);
            }
            catch (JXPathInvalidSyntaxException e) {
                this.logger.debug("[ABORT XPath] Error resolving '{}' from '{}': {}", new Object[]{e, path, docRef.getSource(), e.getMessage()});
                return null;
            }
            catch (JXPathException e) {
                this.logger.debug("[SKIP XPath-Doc] Error resolving '{}' from '{}': {}", new Object[]{e, path, docRef.getSource(), e.getMessage()});
                continue;
            }
            if (result != null) break;
            ++ancestryDepth;
        }
        if (result == null) {
            for (MavenXmlMixin mavenXmlMixin : this.mixins) {
                if (mavenXmlMixin.matches(path)) {
                    result = mavenXmlMixin.getMixin().resolveXPathToRawString(path, true, maxAncestry);
                }
                if (result == null) continue;
                break;
            }
        }
        return result;
    }

    public Node resolveXPathToNode(String path, boolean cachePath, int maxDepth) throws GalleyMavenRuntimeException {
        Node result = null;
        int maxAncestry = maxDepth;
        for (String pathPrefix : this.localOnlyPaths) {
            if (!path.startsWith(pathPrefix)) continue;
            maxAncestry = 0;
            break;
        }
        int ancestryDepth = 0;
        for (DocRef<T> docRef : this.stack) {
            if (maxAncestry > -1 && ancestryDepth > maxAncestry || (result = (Node)docRef.getDocContext().selectSingleNode(path)) != null) break;
            ++ancestryDepth;
        }
        if (result == null) {
            for (MavenXmlMixin mavenXmlMixin : this.mixins) {
                if (mavenXmlMixin.matches(path)) {
                    result = mavenXmlMixin.getMixin().resolveXPathToNode(path, true, maxAncestry);
                }
                if (result == null) continue;
                break;
            }
        }
        return result;
    }

    public synchronized List<Node> resolveXPathToAggregatedNodeList(String path, boolean cachePath, int maxDepth) throws GalleyMavenRuntimeException {
        List<Node> nodes;
        int maxAncestry = maxDepth;
        for (String pathPrefix : this.localOnlyPaths) {
            if (!path.startsWith(pathPrefix)) continue;
            maxAncestry = 0;
            break;
        }
        int ancestryDepth = 0;
        ArrayList<Node> result = new ArrayList<Node>();
        for (DocRef<T> docRef : this.stack) {
            if (maxAncestry > -1 && ancestryDepth > maxAncestry) break;
            nodes = this.getLocalNodeList(docRef.getDocContext(), path);
            if (nodes != null) {
                for (Node node : nodes) {
                    result.add(node);
                }
            }
            ++ancestryDepth;
        }
        for (MavenXmlMixin mavenXmlMixin : this.mixins) {
            if (!mavenXmlMixin.matches(path) || (nodes = mavenXmlMixin.getMixin().resolveXPathToAggregatedNodeList(path, cachePath, maxAncestry)) == null) continue;
            for (Node node : nodes) {
                result.add(node);
            }
        }
        return result;
    }

    public synchronized List<Node> resolveXPathToFirstNodeList(String path, boolean cachePath, int maxDepth) throws GalleyMavenRuntimeException {
        List<Node> result;
        int maxAncestry = maxDepth;
        for (String pathPrefix : this.localOnlyPaths) {
            if (!path.startsWith(pathPrefix)) continue;
            maxAncestry = 0;
            break;
        }
        int ancestryDepth = 0;
        for (DocRef<T> docRef : this.stack) {
            if (maxAncestry > -1 && ancestryDepth > maxAncestry) break;
            result = this.getLocalNodeList(docRef.getDocContext(), path);
            if (result != null) {
                return result;
            }
            ++ancestryDepth;
        }
        for (MavenXmlMixin mavenXmlMixin : this.mixins) {
            if (!mavenXmlMixin.matches(path) || (result = mavenXmlMixin.getMixin().resolveXPathToFirstNodeList(path, cachePath, maxAncestry)) == null) continue;
            return result;
        }
        return null;
    }

    protected List<Node> getLocalNodeList(JXPathContext context, String path) throws GalleyMavenRuntimeException {
        ArrayList<Node> result = new ArrayList<Node>();
        List iter = context.selectNodes(path);
        if (iter != null) {
            for (Object obj : iter) {
                result.add((Node)obj);
            }
        }
        return result;
    }

    public List<String> resolveXPathToAggregatedStringList(String path, boolean cachePath, int maxAncestry) {
        List<Node> nodes = this.resolveXPathToAggregatedNodeList(path, cachePath, maxAncestry);
        ArrayList<String> result = new ArrayList<String>(nodes.size());
        for (Node node : nodes) {
            String txt;
            if (node == null || (txt = node.getTextContent()) == null) continue;
            result.add(txt.trim());
        }
        return result;
    }

    public List<String> resolveXPathToAggregatedStringListFrom(JXPathContext context, String path, boolean cachePath) {
        List<Node> nodes = this.resolveXPathToNodeListFrom(context, path, cachePath);
        ArrayList<String> result = new ArrayList<String>(nodes.size());
        for (Node node : nodes) {
            String txt;
            if (node == null || (txt = node.getTextContent()) == null) continue;
            result.add(txt.trim());
        }
        return result;
    }

    protected synchronized Node resolveXPathToNodeFrom(JXPathContext context, String path, boolean cachePath) {
        return (Node)context.selectSingleNode(path);
    }

    public synchronized List<Node> resolveXPathToNodeListFrom(JXPathContext context, String path, boolean cachePath) throws GalleyMavenRuntimeException {
        ArrayList<Node> result = new ArrayList<Node>();
        List iter = context.selectNodes(path);
        if (iter != null) {
            for (Object obj : iter) {
                result.add((Node)obj);
            }
        }
        return result;
    }

    public List<MavenXmlMixin<T>> getMixins() {
        return this.mixins;
    }

    public void addMixin(MavenXmlMixin<T> mixin) {
        this.mixins.add(mixin);
    }

    public void removeMixin(MavenXmlMixin<T> mixin) {
        this.mixins.remove(mixin);
    }

    public String toXML(Element element) {
        return this.xml.toXML(element);
    }
}

