/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.util;

import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.version.VersionSpec;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.maven.spi.type.TypeMapper;
import org.commonjava.maven.galley.model.TypeMapping;

public final class ArtifactPathUtils {
    private ArtifactPathUtils() {
    }

    public static String formatMetadataPath(ProjectRef ref, String filename) throws TransferException {
        StringBuilder sb = new StringBuilder();
        sb.append(ref.getGroupId().replace('.', '/')).append('/').append(ref.getArtifactId());
        if (ref instanceof ProjectVersionRef) {
            sb.append('/').append(ArtifactPathUtils.formatVersionDirectoryPart((ProjectVersionRef)ref));
        }
        sb.append('/').append(filename == null ? "maven-metadata.xml" : filename);
        return sb.toString();
    }

    public static String formatMetadataPath(String groupId, String filename) {
        return String.format("%s/%s", groupId.replace('.', '/'), filename == null ? "maven-metadata.xml" : filename);
    }

    public static String formatArtifactPath(ProjectVersionRef src, TypeMapper mapper) throws TransferException {
        if (src instanceof ArtifactRef) {
            ArtifactRef ref = (ArtifactRef)src;
            TypeMapping tm = mapper.lookup(ref.getTypeAndClassifier());
            return String.format("%s/%s/%s/%s-%s%s.%s", ref.getGroupId().replace('.', '/'), ref.getArtifactId(), ArtifactPathUtils.formatVersionDirectoryPart((ProjectVersionRef)ref), ref.getArtifactId(), ArtifactPathUtils.formatVersionFilePart((ProjectVersionRef)ref), tm.getClassifier() == null ? "" : "-" + tm.getClassifier(), tm.getExtension());
        }
        return String.format("%s/%s/%s/", src.getGroupId().replace('.', '/'), src.getArtifactId(), ArtifactPathUtils.formatVersionDirectoryPart(src));
    }

    public static String formatVersionDirectoryPart(ProjectVersionRef ref) throws TransferException {
        VersionSpec vs = ref.getVersionSpec();
        if (!vs.isSingle()) {
            throw new TransferException("Cannot format version directory part for: '{}'. Version is compound.", new Object[]{ref});
        }
        if (vs.isSnapshot()) {
            return vs.getSingleVersion().getBaseVersion().renderStandard() + "-SNAPSHOT";
        }
        return vs.renderStandard();
    }

    public static String formatVersionFilePart(ProjectVersionRef ref) throws TransferException {
        VersionSpec vs = ref.getVersionSpec();
        if (!vs.isSingle()) {
            throw new TransferException("Cannot format version filename part for: '{}'. Version is compound.", new Object[]{ref});
        }
        return vs.renderStandard();
    }
}

