/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.valuegenerator;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.valuegenerator.AbstractRDBMSGenerator;
import org.datanucleus.store.rdbms.valuegenerator.SequenceTable;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.store.valuegenerator.ValueGenerationException;
import org.datanucleus.util.NucleusLogger;

public final class TableGenerator
extends AbstractRDBMSGenerator {
    private SequenceTable sequenceTable = null;
    private final String sequenceName;
    public static final String DEFAULT_TABLE_NAME = "SEQUENCE_TABLE";
    public static final String DEFAULT_SEQUENCE_COLUMN_NAME = "SEQUENCE_NAME";
    public static final String DEFAULT_NEXTVALUE_COLUMN_NAME = "NEXT_VAL";
    boolean repositoryExists = false;

    public TableGenerator(String name, Properties props) {
        super(name, props);
        this.allocationSize = 5;
        if (this.properties != null) {
            if (this.properties.get("key-cache-size") != null) {
                try {
                    this.allocationSize = Integer.parseInt(this.properties.getProperty("key-cache-size"));
                }
                catch (Exception e) {
                    throw new ValueGenerationException(LOCALISER.msg("Sequence040006", this.properties.get("key-cache-size")));
                }
            }
            if (this.properties.get("key-initial-value") != null) {
                try {
                    this.initialValue = Integer.parseInt(this.properties.getProperty("key-initial-value"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.sequenceName = this.properties.getProperty("sequence-name") != null ? this.properties.getProperty("sequence-name") : (this.properties.getProperty("sequence-table-basis") != null && this.properties.getProperty("sequence-table-basis").equalsIgnoreCase("table") ? this.properties.getProperty("table-name") : this.properties.getProperty("root-class-name"));
        } else {
            this.sequenceName = "SEQUENCENAME";
        }
    }

    public SequenceTable getTable() {
        return this.sequenceTable;
    }

    public ValueGenerationBlock reserveBlock(long size) {
        if (size < 1L) {
            return null;
        }
        ArrayList<Long> oid = new ArrayList<Long>();
        try {
            if (this.sequenceTable == null) {
                this.initialiseSequenceTable();
            }
            DatastoreIdentifier sourceTableIdentifier = null;
            if (this.properties.getProperty("table-name") != null) {
                sourceTableIdentifier = ((MappedStoreManager)this.storeMgr).getIdentifierFactory().newDatastoreContainerIdentifier(this.properties.getProperty("table-name"));
            }
            Long nextId = this.sequenceTable.getNextVal(this.sequenceName, this.connection, (int)size, sourceTableIdentifier, this.properties.getProperty("column-name"), this.initialValue);
            int i = 0;
            while ((long)i < size) {
                oid.add(nextId);
                nextId = nextId + 1L;
                ++i;
            }
            if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
                NucleusLogger.VALUEGENERATION.debug((Object)LOCALISER.msg("040004", (Object)("" + size)));
            }
            return new ValueGenerationBlock(oid);
        }
        catch (SQLException e) {
            throw new ValueGenerationException(LOCALISER_RDBMS.msg("061001", (Object)e.getMessage()));
        }
    }

    protected boolean requiresRepository() {
        return true;
    }

    protected boolean repositoryExists() {
        if (this.repositoryExists) {
            return this.repositoryExists;
        }
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.rdbms.omitDatabaseMetaDataGetColumns")) {
            this.repositoryExists = true;
            return this.repositoryExists;
        }
        try {
            if (this.sequenceTable == null) {
                this.initialiseSequenceTable();
            }
            this.sequenceTable.exists((Connection)this.connection.getConnection(), true);
            this.repositoryExists = true;
            return true;
        }
        catch (SQLException sqle) {
            throw new ValueGenerationException("Exception thrown calling table.exists() for " + this.sequenceTable, (Throwable)sqle);
        }
    }

    protected boolean createRepository() {
        try {
            if (this.sequenceTable == null) {
                this.initialiseSequenceTable();
            }
            this.sequenceTable.exists((Connection)this.connection.getConnection(), true);
            this.repositoryExists = true;
            return true;
        }
        catch (SQLException sqle) {
            throw new ValueGenerationException("Exception thrown calling table.exists() for " + this.sequenceTable, (Throwable)sqle);
        }
    }

    protected void initialiseSequenceTable() {
        DatastoreClass table;
        String schemaName;
        String catalogName = this.properties.getProperty("sequence-catalog-name");
        if (catalogName == null) {
            catalogName = this.properties.getProperty("catalog-name");
        }
        if ((schemaName = this.properties.getProperty("sequence-schema-name")) == null) {
            schemaName = this.properties.getProperty("schema-name");
        }
        String tableName = this.properties.getProperty("sequence-table-name") == null ? DEFAULT_TABLE_NAME : this.properties.getProperty("sequence-table-name");
        MappedStoreManager storeMgr = (MappedStoreManager)this.storeMgr;
        DatastoreAdapter dba = storeMgr.getDatastoreAdapter();
        DatastoreIdentifier identifier = storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(tableName);
        if (dba.supportsOption("CatalogInTableDefinition") && catalogName != null) {
            identifier.setCatalogName(catalogName);
        }
        if (dba.supportsOption("SchemaInTableDefinition") && schemaName != null) {
            identifier.setSchemaName(schemaName);
        }
        if ((table = storeMgr.getDatastoreClass(identifier)) != null) {
            this.sequenceTable = (SequenceTable)table;
        } else {
            String sequenceNameColumnName = DEFAULT_SEQUENCE_COLUMN_NAME;
            String nextValColumnName = DEFAULT_NEXTVALUE_COLUMN_NAME;
            if (this.properties.getProperty("sequence-name-column-name") != null) {
                sequenceNameColumnName = this.properties.getProperty("sequence-name-column-name");
            }
            if (this.properties.getProperty("sequence-nextval-column-name") != null) {
                nextValColumnName = this.properties.getProperty("sequence-nextval-column-name");
            }
            this.sequenceTable = new SequenceTable(identifier, (RDBMSStoreManager)storeMgr, sequenceNameColumnName, nextValColumnName);
            this.sequenceTable.initialize(storeMgr.getOMFContext().getClassLoaderResolver(null));
            storeMgr.addDatastoreContainer((DatastoreContainerObject)this.sequenceTable);
        }
    }
}

