/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.column;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.column.AbstractColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public class BooleanColumnMapping
extends AbstractColumnMapping {
    public BooleanColumnMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        this.initTypeInfo();
    }

    @Override
    public boolean isBooleanBased() {
        return true;
    }

    @Override
    public int getJDBCType() {
        return 16;
    }

    @Override
    public void setBoolean(PreparedStatement ps, int param, boolean value) {
        try {
            ps.setBoolean(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"boolean", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public boolean getBoolean(ResultSet rs, int param) {
        boolean value;
        try {
            value = rs.getBoolean(param);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"Boolean", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setString(PreparedStatement ps, int param, String value) {
        try {
            if (value == null) {
                ps.setNull(param, this.getJDBCType());
            } else {
                ps.setBoolean(param, value.equals("Y"));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"String", value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public String getString(ResultSet rs, int param) {
        String value;
        try {
            value = rs.getBoolean(param) ? "Y" : "N";
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"String", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setObject(PreparedStatement ps, int param, Object value) {
        block5: {
            try {
                if (value == null) {
                    ps.setNull(param, this.getJDBCType());
                    break block5;
                }
                if (value instanceof String) {
                    ps.setBoolean(param, value.equals("Y"));
                    break block5;
                }
                if (value instanceof Boolean) {
                    ps.setBoolean(param, (Boolean)value);
                    break block5;
                }
                throw new NucleusUserException(Localiser.msg((String)"055004", (Object[])new Object[]{value, this.column}));
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"Object", "" + value, this.column, e.getMessage()}), (Throwable)e);
            }
        }
    }

    @Override
    public Object getObject(ResultSet rs, int param) {
        Object value;
        try {
            boolean b = rs.getBoolean(param);
            value = rs.wasNull() ? null : (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_STRING) ? (b ? "Y" : "N") : (b ? Boolean.TRUE : Boolean.FALSE));
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"Object", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }
}

