/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.request.RequestType;
import org.datanucleus.store.rdbms.table.DatastoreClass;

public class RequestIdentifier {
    private final DatastoreClass table;
    private final int[] memberNumbers;
    private final int[] secondaryMemberNumbers;
    private final RequestType type;
    private final int hashCode;
    private final String className;
    private final BitSet nullPkFields;
    private final boolean noVersionUpdate;

    public RequestIdentifier(DatastoreClass table, AbstractMemberMetaData[] mmds, RequestType type, String className) {
        this(table, mmds, null, type, className, null);
    }

    public RequestIdentifier(DatastoreClass table, AbstractMemberMetaData[] mmds, AbstractMemberMetaData[] secondaryMmds, RequestType type, String className, BitSet nullPkFields) {
        this(table, mmds, secondaryMmds, type, className, nullPkFields, false);
    }

    public RequestIdentifier(DatastoreClass table, AbstractMemberMetaData[] mmds, AbstractMemberMetaData[] secondaryMmds, RequestType type, String className, BitSet nullPkFields, boolean noVersionUpdate) {
        int i;
        this.table = table;
        this.type = type;
        this.className = className;
        this.nullPkFields = nullPkFields;
        this.noVersionUpdate = noVersionUpdate;
        if (mmds == null) {
            this.memberNumbers = null;
        } else {
            this.memberNumbers = new int[mmds.length];
            for (i = 0; i < this.memberNumbers.length; ++i) {
                this.memberNumbers[i] = mmds[i].getAbsoluteFieldNumber();
            }
            Arrays.sort(this.memberNumbers);
        }
        if (secondaryMmds == null) {
            this.secondaryMemberNumbers = null;
        } else {
            this.secondaryMemberNumbers = new int[secondaryMmds.length];
            for (i = 0; i < this.secondaryMemberNumbers.length; ++i) {
                this.secondaryMemberNumbers[i] = secondaryMmds[i].getAbsoluteFieldNumber();
            }
            Arrays.sort(this.secondaryMemberNumbers);
        }
        int tmpHash = Objects.hash(new Object[]{table, type, className, nullPkFields, noVersionUpdate});
        tmpHash = 31 * tmpHash + Arrays.hashCode(this.memberNumbers);
        this.hashCode = tmpHash = 31 * tmpHash + Arrays.hashCode(this.secondaryMemberNumbers);
    }

    public DatastoreClass getTable() {
        return this.table;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestIdentifier)) {
            return false;
        }
        RequestIdentifier ri = (RequestIdentifier)o;
        if (this.hashCode != ri.hashCode) {
            return false;
        }
        return this.table.equals(ri.table) && this.type.equals((Object)ri.type) && this.className.equals(ri.className) && Objects.equals(this.nullPkFields, ri.nullPkFields) && this.noVersionUpdate == ri.noVersionUpdate && Arrays.equals(this.memberNumbers, ri.memberNumbers) && Arrays.equals(this.secondaryMemberNumbers, ri.secondaryMemberNumbers);
    }
}

