/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.enums;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AceFlags {
    FILE_INHERIT_ACE(1, 'f'),
    DIRECTORY_INHERIT_ACE(2, 'd'),
    INHERIT_ONLY_ACE(8, 'o'),
    IDENTIFIER_GROUP(64, 'g');

    private static final Logger logger;
    private final int _value;
    private final char _abbreviation;

    private AceFlags(int value, char abbreviation) {
        this._value = value;
        this._abbreviation = abbreviation;
    }

    public int getValue() {
        return this._value;
    }

    public char getAbbreviation() {
        return this._abbreviation;
    }

    public boolean matches(int flags) {
        return (this._value & flags) == this._value;
    }

    public static String asString(int flags) {
        if (flags == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (AceFlags flag : AceFlags.values()) {
            if (!flag.matches(flags)) continue;
            sb.append(flag.getAbbreviation());
        }
        return sb.toString();
    }

    public static int validate(int flags, boolean isDir) {
        int res = 0;
        if (isDir) {
            if (FILE_INHERIT_ACE.matches(flags)) {
                res = AceFlags.FILE_INHERIT_ACE._value;
            }
            if (DIRECTORY_INHERIT_ACE.matches(flags)) {
                res += AceFlags.DIRECTORY_INHERIT_ACE._value;
            }
            if (INHERIT_ONLY_ACE.matches(flags)) {
                if (res == 0) {
                    logger.warn("Unsupported flags of directory: " + flags);
                } else {
                    res += AceFlags.INHERIT_ONLY_ACE._value;
                }
            }
        } else if (flags != 0 && flags != AceFlags.IDENTIFIER_GROUP._value) {
            logger.warn("Unsupported flags of file: " + flags);
        }
        if (IDENTIFIER_GROUP.matches(flags)) {
            res += AceFlags.IDENTIFIER_GROUP._value;
        }
        return res;
    }

    public static int parseInt(String strFlags) throws IllegalArgumentException {
        char[] chars;
        if (strFlags == null || strFlags.length() == 0) {
            throw new IllegalArgumentException("Ace flags string is " + (strFlags == null ? "NULL" : "Empty"));
        }
        int mask = 0;
        for (char ch : chars = strFlags.toCharArray()) {
            mask |= AceFlags.fromAbbreviation((char)ch)._value;
        }
        return mask;
    }

    public static AceFlags fromAbbreviation(char abbreviation) throws IllegalArgumentException {
        switch (abbreviation) {
            case 'f': {
                return FILE_INHERIT_ACE;
            }
            case 'd': {
                return DIRECTORY_INHERIT_ACE;
            }
            case 'o': {
                return INHERIT_ONLY_ACE;
            }
            case 'g': {
                return IDENTIFIER_GROUP;
            }
        }
        throw new IllegalArgumentException("Invalid ace flag abbreviation: " + abbreviation);
    }

    static {
        logger = LoggerFactory.getLogger((String)("logger.org.dcache.authorization." + AceFlags.class));
    }
}

