/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.enums;

public enum AccessAttribute {
    ACCESS4_READ(1, 'r'),
    ACCESS4_LOOKUP(2, 'l'),
    ACCESS4_MODIFY(4, 'm'),
    ACCESS4_EXTEND(8, 'e'),
    ACCESS4_DELETE(16, 'd'),
    ACCESS4_EXECUTE(32, 'x');

    private final int _value;
    private final char _abbreviation;

    private AccessAttribute(int value, char abbreviation) {
        this._value = value;
        this._abbreviation = abbreviation;
    }

    public int getValue() {
        return this._value;
    }

    public char getAbbreviation() {
        return this._abbreviation;
    }

    public boolean equals(int value) {
        return this._value == value;
    }

    public boolean matches(int flags) {
        return (this._value & flags) == this._value;
    }

    public static AccessAttribute valueOf(int attribute) throws IllegalArgumentException {
        for (AccessAttribute attr : AccessAttribute.values()) {
            if (attr._value != attribute) continue;
            return attr;
        }
        throw new IllegalArgumentException("Illegal argument (value of access attribute): " + attribute);
    }

    public static String asString(int attributes) {
        if (attributes == 0) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        for (AccessAttribute attribute : AccessAttribute.values()) {
            if (!attribute.matches(attributes)) continue;
            sb.append(attribute.getAbbreviation());
        }
        return sb.toString();
    }
}

