/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.enums;

public enum AceType {
    ACCESS_ALLOWED_ACE_TYPE(0, 'A'),
    ACCESS_DENIED_ACE_TYPE(1, 'D'),
    ACCESS_AUDIT_ACE_TYPE(2, 'U'),
    ACCESS_ALARM_ACE_TYPE(3, 'L');

    private final int _value;
    private final char _abbreviation;

    private AceType(int value, char abbreviation) {
        this._value = value;
        this._abbreviation = abbreviation;
    }

    public int getValue() {
        return this._value;
    }

    public char getAbbreviation() {
        return this._abbreviation;
    }

    public boolean equals(int value) {
        return this._value == value;
    }

    public boolean equals(char abbreviation) {
        return this._abbreviation == abbreviation;
    }

    public boolean equalsIgnoreCase(char abbreviation) {
        return Character.toUpperCase(this._abbreviation) == Character.toUpperCase(abbreviation);
    }

    public String toString() {
        return String.valueOf(this._abbreviation);
    }

    public static AceType fromAbbreviation(char abbreviation) throws IllegalArgumentException {
        for (AceType type : AceType.values()) {
            if (!type.equalsIgnoreCase(abbreviation)) continue;
            return type;
        }
        throw new IllegalArgumentException("Invalid ACE type abbreviation: " + abbreviation);
    }

    public static AceType fromAbbreviation(String abbreviation) throws IllegalArgumentException {
        if (abbreviation == null || abbreviation.length() != 1) {
            throw new IllegalArgumentException((String)(abbreviation == null ? "ACE type abbreviation is NULL" : (abbreviation.length() == 0 ? "ACE type abbreviation is Empty" : "Invalid ACE type abbreviation: " + abbreviation)));
        }
        return AceType.fromAbbreviation(abbreviation.charAt(0));
    }

    public static AceType valueOf(int value) throws IllegalArgumentException {
        for (AceType type : AceType.values()) {
            if (type.getValue() != value) continue;
            return type;
        }
        throw new IllegalArgumentException("Illegal value of ACE type): " + value);
    }
}

