/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl;

import org.dcache.acl.enums.AccessMask;
import org.dcache.acl.enums.RsType;

public class Permission {
    public static final int ALLOW_ALL = 0x1F01FF;
    private int _defMsk = 0;
    private int _allowMsk = 0;

    public Permission() {
    }

    public Permission(int defMsk, int allowMsk) {
        this._defMsk = defMsk;
        this._allowMsk = allowMsk;
    }

    public int getDefMsk() {
        return this._defMsk;
    }

    public void setDefMsk(int defMsk) {
        this._defMsk = defMsk;
    }

    public void appendDefMsk(int defMsk) {
        this._defMsk |= defMsk;
    }

    public int getAllowMsk() {
        return this._allowMsk;
    }

    public void setAllowMsk(int allowMsk) {
        this._allowMsk = allowMsk;
    }

    public void appendAllowMsk(int allowMsk) {
        this._allowMsk |= allowMsk;
    }

    public int getDenyMsk() {
        return this._defMsk ^ this._allowMsk;
    }

    public void setAll() {
        this._allowMsk = 0x1F01FF;
        this._defMsk = 0x1F01FF;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("defMsk = ").append(Integer.toBinaryString(this._defMsk));
        sb.append(", allowMsk = ").append(Integer.toBinaryString(this._allowMsk));
        sb.append(", denyMsk = ").append(Integer.toBinaryString(this._defMsk ^ this._allowMsk));
        return sb.toString();
    }

    public String asString(RsType rsType) {
        if (this._defMsk == 0) {
            return "has not been defined";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("defMsk = ").append(AccessMask.asString(this._defMsk, rsType));
        if (this._allowMsk != 0) {
            sb.append(", allowMsk = ").append(AccessMask.asString(this._allowMsk, rsType));
        }
        if ((this._defMsk ^ this._allowMsk) != 0) {
            sb.append(", denyMsk = ").append(AccessMask.asString(this._defMsk ^ this._allowMsk, rsType));
        }
        return sb.toString();
    }
}

