/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.mapper;

import java.util.List;
import javax.security.auth.Subject;
import org.dcache.acl.ACE;
import org.dcache.acl.ACL;
import org.dcache.acl.ACLException;
import org.dcache.acl.Owner;
import org.dcache.acl.Permission;
import org.dcache.acl.enums.AceFlags;
import org.dcache.acl.enums.RsType;
import org.dcache.acl.util.net.InetAddressMatcher;
import org.dcache.auth.Origin;
import org.dcache.auth.Subjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclMapper {
    private static final Logger logger = LoggerFactory.getLogger((String)("logger.org.dcache.authorization." + AclMapper.class.getName()));

    private AclMapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Permission getPermission(Subject subject, Origin origin, Owner owner, ACL acl) {
        RsType rsType;
        Permission permACL;
        block9: {
            block8: {
                permACL = new Permission();
                rsType = null;
                if (!Subjects.isRoot((Subject)subject)) break block8;
                permACL.setAll();
                if (logger.isDebugEnabled()) {
                    logger.debug("ROOT has an access to everything.");
                }
                Permission permission = permACL;
                if (!logger.isDebugEnabled()) return permission;
                logger.debug("Getted Permission: " + (rsType == null ? permACL.toString() : permACL.asString(rsType)));
                return permission;
            }
            if (acl != null) break block9;
            Permission permission = permACL;
            if (!logger.isDebugEnabled()) return permission;
            logger.debug("Getted Permission: " + (rsType == null ? permACL.toString() : permACL.asString(rsType)));
            return permission;
        }
        try {
            rsType = acl.getRsType();
            int def_msk = 0;
            int allow_msk = 0;
            List<ACE> aces = acl.getList();
            for (ACE ace : aces) {
                int mask;
                Permission permACE = AclMapper.getPermission(subject, origin, owner, ace, rsType);
                if (permACE == null || (mask = permACE.getDefMsk() & ~def_msk) == 0) continue;
                def_msk |= mask;
                if (permACE.getAllowMsk() != 0) continue;
                allow_msk |= mask;
            }
            permACL.setDefMsk(def_msk);
            permACL.setAllowMsk(allow_msk);
        }
        catch (ACLException e) {
            try {
                logger.error(e.getMessage());
            }
            catch (Throwable throwable) {
                if (!logger.isDebugEnabled()) throw throwable;
                logger.debug("Getted Permission: " + (rsType == null ? permACL.toString() : permACL.asString(rsType)));
                throw throwable;
            }
            if (!logger.isDebugEnabled()) return permACL;
            logger.debug("Getted Permission: " + (rsType == null ? permACL.toString() : permACL.asString(rsType)));
            return permACL;
        }
        if (!logger.isDebugEnabled()) return permACL;
        logger.debug("Getted Permission: " + (rsType == null ? permACL.toString() : permACL.asString(rsType)));
        return permACL;
    }

    public static Permission[] getPermissions(Subject subject, Origin origin, Owner[] owners, ACL[] acls) {
        int len = acls.length;
        Permission[] perms = new Permission[len];
        for (int index = 0; index < len; ++index) {
            perms[index] = AclMapper.getPermission(subject, origin, owners[index], acls[index]);
        }
        return perms;
    }

    private static Permission getPermission(Subject subject, Origin origin, Owner owner, ACE ace, RsType rsType) throws ACLException {
        Permission perm = null;
        if (rsType == RsType.DIR && AceFlags.INHERIT_ONLY_ACE.matches(ace.getFlags())) {
            return null;
        }
        boolean isAddressMatches = origin == null ? true : InetAddressMatcher.matches(ace.getAddressMsk(), origin.getAddress());
        if (!isAddressMatches) {
            return null;
        }
        switch (ace.getWho()) {
            case OWNER: {
                if (!Subjects.hasUid((Subject)subject, (long)owner.getUid())) break;
                perm = new Permission(ace.getAccessMsk(), ace.getType().getValue());
                break;
            }
            case OWNER_GROUP: {
                if (!Subjects.hasGid((Subject)subject, (long)owner.getGid())) break;
                perm = new Permission(ace.getAccessMsk(), ace.getType().getValue());
                break;
            }
            case EVERYONE: {
                perm = new Permission(ace.getAccessMsk(), ace.getType().getValue());
                break;
            }
            case ANONYMOUS: {
                if (origin != null && origin.getAuthType() == Origin.AuthType.ORIGIN_AUTHTYPE_WEAK) {
                    perm = new Permission(ace.getAccessMsk(), ace.getType().getValue());
                    break;
                }
                if (origin != null) break;
                perm = new Permission(ace.getAccessMsk(), ace.getType().getValue());
                break;
            }
            case AUTHENTICATED: {
                if (origin != null && origin.getAuthType() == Origin.AuthType.ORIGIN_AUTHTYPE_STRONG) {
                    perm = new Permission(ace.getAccessMsk(), ace.getType().getValue());
                    break;
                }
                if (origin != null) break;
                perm = new Permission(ace.getAccessMsk(), ace.getType().getValue());
                break;
            }
            case USER: {
                if (!Subjects.hasUid((Subject)subject, (long)ace.getWhoID())) break;
                perm = new Permission(ace.getAccessMsk(), ace.getType().getValue());
                break;
            }
            case GROUP: {
                if (!Subjects.hasGid((Subject)subject, (long)ace.getWhoID())) break;
                perm = new Permission(ace.getAccessMsk(), ace.getType().getValue());
                break;
            }
            default: {
                throw new ACLException("Get Permission", "Invalid who: " + (Object)((Object)ace.getWho()));
            }
        }
        return perm;
    }
}

