/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.parser;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.dcache.acl.ACE;
import org.dcache.acl.enums.AccessMask;
import org.dcache.acl.enums.AceFlags;
import org.dcache.acl.enums.AceType;
import org.dcache.acl.enums.Who;

public class ACEParser {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final String SPACE_SEPARATOR = " ";
    private static final String SEPARATOR = ":";
    private static final int ACES_MIN = 1;
    private static final int ACE_MIN = 3;
    private static final int ACE_MAX = 6;
    private static final int ACE_MIN_ADM = 2;
    private static final int ACE_MAX_ADM = 5;
    private static ACEParser _SINGLETON = new ACEParser();

    private ACEParser() {
    }

    public static ACEParser instance() {
        return _SINGLETON;
    }

    public static ACE parse(String ace_spec) throws IllegalArgumentException {
        String sAccessMsk;
        int accessMsk;
        String sWho;
        Who who;
        if (ace_spec == null || ace_spec.length() == 0) {
            throw new IllegalArgumentException("ace_spec is " + (ace_spec == null ? "NULL" : "Empty"));
        }
        if (ace_spec.endsWith(SEPARATOR)) {
            throw new IllegalArgumentException("ace_spec ends with \":\"");
        }
        if (ace_spec.contains(":+") || ace_spec.contains(":-")) {
            return ACEParser.parseAdmACE(ace_spec);
        }
        String[] split = ace_spec.split(SEPARATOR);
        if (split == null) {
            throw new IllegalArgumentException("ace_spec can't be splitted.");
        }
        int len = split.length;
        if (len < 3 || len > 6) {
            throw new IllegalArgumentException("Count tags invalid.");
        }
        int index = 0;
        if ((who = Who.fromAbbreviation(sWho = split[index++])) == null) {
            throw new IllegalArgumentException("Invalid who abbreviation: " + sWho);
        }
        int whoID = -1;
        if (who == Who.USER || who == Who.GROUP) {
            String sWhoID = split[index++];
            try {
                whoID = Integer.parseInt(sWhoID);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid whoID. NumberFormatException: " + e.getMessage());
            }
        }
        if ((accessMsk = AccessMask.parseInt(sAccessMsk = split[index++])) == 0) {
            throw new IllegalArgumentException("Invalid accessMask: " + sAccessMsk);
        }
        if (index >= len) {
            throw new IllegalArgumentException("Unspecified ACE type.");
        }
        String s = split[index++];
        int flags = 0;
        try {
            flags = AceFlags.parseInt(s);
            s = null;
        }
        catch (IllegalArgumentException Ignore) {
            // empty catch block
        }
        if (s == null) {
            if (index >= len) {
                throw new IllegalArgumentException("Unspecified ACE type.");
            }
            s = split[index++];
        }
        AceType type = AceType.fromAbbreviation(s);
        String addressMsk = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
        if (index < len) {
            addressMsk = split[index++];
            try {
                new BigInteger(addressMsk, 16);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid addressMask. NumberFormatException: " + e.getMessage());
            }
        }
        if (index != len) {
            throw new IllegalArgumentException("Check index failure. Invalid ace_spec: " + ace_spec);
        }
        return new ACE(type, flags, accessMsk, who, whoID, addressMsk);
    }

    public static ACE parseAdmACE(String ace_spec) throws IllegalArgumentException {
        AceType type;
        String sAccessMsk;
        char operator;
        String sWho;
        Who who;
        if (ace_spec == null || ace_spec.length() == 0) {
            throw new IllegalArgumentException("ace_spec is " + (ace_spec == null ? "NULL" : "Empty"));
        }
        if (ace_spec.endsWith(SEPARATOR)) {
            throw new IllegalArgumentException("ace_spec ends with \":\"");
        }
        String[] split = ace_spec.split(SEPARATOR);
        if (split == null) {
            throw new IllegalArgumentException("ace_spec can't be splitted.");
        }
        int len = split.length;
        if (len < 2 || len > 5) {
            throw new IllegalArgumentException("Count tags invalid.");
        }
        int index = 0;
        if ((who = Who.fromAbbreviation(sWho = split[index++])) == null) {
            throw new IllegalArgumentException("Invalid who abbreviation: " + sWho);
        }
        int whoID = -1;
        if (Who.USER.equals((Object)who) || Who.GROUP.equals((Object)who)) {
            String sWhoID = split[index++];
            if (index >= len) {
                throw new IllegalArgumentException("Unspecified accessMask.");
            }
            try {
                whoID = Integer.parseInt(sWhoID);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid whoID. NumberFormatException: " + e.getMessage());
            }
        }
        if ((operator = (sAccessMsk = split[index++]).charAt(0)) == '+') {
            type = AceType.ACCESS_ALLOWED_ACE_TYPE;
        } else if (operator == '-') {
            type = AceType.ACCESS_DENIED_ACE_TYPE;
        } else {
            throw new IllegalArgumentException("Invalid operator: \"" + operator + "\"");
        }
        int accessMsk = AccessMask.parseInt(sAccessMsk.substring(1));
        if (accessMsk == 0) {
            throw new IllegalArgumentException("Invalid accessMask: " + sAccessMsk);
        }
        String addressMsk = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
        int flags = 0;
        if (index < len) {
            String s;
            if ((s = split[index++]).trim().length() == 0) {
                throw new IllegalArgumentException("ACE flags is Empty.");
            }
            try {
                flags = AceFlags.parseInt(s);
                s = null;
            }
            catch (IllegalArgumentException Ignore) {
                // empty catch block
            }
            if (s == null && index < len) {
                s = split[index++];
            }
            if (s != null) {
                try {
                    new BigInteger(s, 16);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid addressMask. NumberFormatException: " + e.getMessage());
                }
                addressMsk = s;
            }
        }
        if (index != len) {
            throw new IllegalArgumentException("Check index failure. Invalid ace_spec: " + ace_spec);
        }
        return new ACE(type, flags, accessMsk, who, whoID, addressMsk);
    }

    public static List<ACE> parseAdm(String aces_spec) throws IllegalArgumentException {
        if (aces_spec == null || aces_spec.length() == 0) {
            throw new IllegalArgumentException("aces_spec is " + (aces_spec == null ? "NULL" : "Empty"));
        }
        String[] split = aces_spec.split(SPACE_SEPARATOR);
        if (split == null) {
            throw new IllegalArgumentException("aces_spec can't be splitted.");
        }
        int len = split.length;
        if (len < 1) {
            throw new IllegalArgumentException("Count ACEs invalid.");
        }
        ArrayList<ACE> aces = new ArrayList<ACE>(len);
        for (String ace : split) {
            aces.add(ACEParser.parseAdmACE(ace));
        }
        return aces;
    }
}

