/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.unix;

public enum AceTag {
    UNDEFINED_TAG(0, ""),
    DEFAULT(4096, "default"),
    USER_OBJ(1, "user"),
    GROUP_OBJ(4, "group"),
    OTHER_OBJ(32, "other");

    private static final String SEPARATOR = ":";
    private final int _value;
    private final String _abbreviation;

    private AceTag(int value, String abbreviation) {
        this._value = value;
        this._abbreviation = abbreviation;
    }

    public int getValue() {
        return this._value;
    }

    public String getAbbreviation() {
        return this._abbreviation;
    }

    public boolean equals(int value) {
        return this._value == value;
    }

    public boolean matches(int tags) {
        return (this._value & tags) == this._value;
    }

    public static String toString(int tags) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder();
        for (AceTag tag : AceTag.values()) {
            if (!tag.matches(tags)) continue;
            if (sb.length() != 0) {
                sb.append(SEPARATOR);
            }
            sb.append(tag.getAbbreviation());
        }
        return sb.toString();
    }
}

