/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.applets.login;

import dmg.cells.applets.login.KeyValueLayout;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class HelloPanel
extends Panel
implements ActionListener {
    private static final long serialVersionUID = -4656680180977452566L;
    private Component _picture = new PictureCanvas();
    private Button _setupButton = new Button("Setup");
    private Button _exitButton = new Button("Exit");
    private Label _messageLabel = new Label("");
    private Label _title;
    private Color _ourColor = new Color(10, 100, 200);
    private Font _standardFont = new Font("SansSerif", 0, 16);
    private Font _veryBigFont = new Font("SansSerif", 3, 50);
    private LoginPanel _loginPanel;
    private SetupPanel _setupPanel;
    private int _b = 10;
    private ActionListener _actionListener;

    @Override
    public Insets getInsets() {
        return new Insets(this._b, this._b, this._b, this._b);
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        int h = this._b / 2;
        g.setColor(this._ourColor);
        int[] xs = new int[4];
        int[] ys = new int[4];
        xs[0] = h;
        ys[0] = h;
        xs[1] = d.width - h - 1;
        ys[1] = h;
        xs[2] = d.width - h - 1;
        ys[2] = d.height - h - 1;
        xs[3] = h;
        ys[3] = d.height - h - 1;
        g.drawPolygon(xs, ys, xs.length);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(500, 200);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void setHost(String host, boolean visible, boolean changable) {
        this._setupPanel.setHost(host, visible, changable);
    }

    public void setPort(String port, boolean visible, boolean changable) {
        this._setupPanel.setPort(port, visible, changable);
    }

    public void setUser(String user, boolean visible, boolean changable) {
        this._loginPanel.setUser(user, visible, changable);
    }

    public String getUser() {
        return this._loginPanel.getUser();
    }

    public String getHost() {
        return this._setupPanel.getHost();
    }

    public String getPort() {
        return this._setupPanel.getPort();
    }

    public String getPassword() {
        return this._loginPanel.getPassword();
    }

    public void setText(String message) {
        if (message.equals("")) {
            this._messageLabel.setText("");
        } else {
            this._messageLabel.setForeground(Color.red);
            this._messageLabel.setText(message);
        }
    }

    public void addActionListener(ActionListener listener) {
        this._actionListener = listener;
    }

    private void informActionListeners(String msg) {
        if (this._actionListener != null) {
            this._actionListener.actionPerformed(new ActionEvent(this, 0, msg));
        }
    }

    public void setTitle(String title) {
    }

    public void ok() {
    }

    public HelloPanel(String title) {
        this._title = new Label(title, 1);
        this._title.setFont(new Font("SansSerif", 1, 24));
        this._title.setForeground(this._ourColor);
        BorderLayout masterLayout = new BorderLayout();
        masterLayout.setHgap(10);
        masterLayout.setVgap(10);
        this.setLayout(masterLayout);
        this.add((Component)this._title, "North");
        this.add(this._picture, "West");
        this._loginPanel = new LoginPanel();
        this._loginPanel.addActionListener(this);
        this._setupPanel = new SetupPanel();
        this.add((Component)this._loginPanel, "Center");
        BorderLayout bottomLayout = new BorderLayout();
        bottomLayout.setHgap(10);
        bottomLayout.setVgap(10);
        Panel bottomPanel = new Panel(bottomLayout);
        this._setupButton.setFont(this._standardFont);
        this._setupButton.addActionListener(this);
        this._exitButton.setFont(this._standardFont);
        this._exitButton.addActionListener(this);
        bottomPanel.add((Component)this._setupButton, "West");
        bottomPanel.add((Component)this._exitButton, "East");
        bottomPanel.add((Component)this._messageLabel, "Center");
        this.add((Component)bottomPanel, "South");
    }

    @Override
    public void setEnabled(boolean enable) {
        this._setupPanel.setEnabled(enable);
        this._loginPanel.setEnabled(enable);
    }

    @Override
    public synchronized void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        Object obj = event.getSource();
        if (obj == this._exitButton) {
            this.informActionListeners("exit");
        } else if (obj == this._setupButton) {
            if (command.equals("Setup")) {
                this._setupButton.setLabel("Login");
                this.remove(this._loginPanel);
                this._setupPanel.validate();
                this.add((Component)this._setupPanel, "Center");
                this.validate();
            } else {
                this._setupButton.setLabel("Setup");
                this.remove(this._setupPanel);
                this.add((Component)this._loginPanel, "Center");
            }
            this.repaint();
        } else if (obj == this._loginPanel._passwordText) {
            if (this._loginPanel.getUser().equals("") || this._loginPanel.getPassword().equals("") || this._setupPanel.getHost().equals("") || this._setupPanel.getPort().equals("")) {
                this.setText("Not enough arguments");
            } else {
                this.setText("");
                this.informActionListeners("go");
            }
        }
    }

    private class SetupPanel
    extends Panel {
        private static final long serialVersionUID = 8087686727349989924L;
        private TextField _hostText = new TextField("");
        private TextField _portText = new TextField("");

        public SetupPanel() {
            this.setBackground(Color.green);
            KeyValueLayout kvl = new KeyValueLayout();
            kvl.setHgap(10);
            kvl.setVgap(10);
            this.setLayout(kvl);
            Label hostLabel = new Label("Hostname");
            Label portLabel = new Label("Portnumber");
            hostLabel.setFont(HelloPanel.this._standardFont);
            portLabel.setFont(HelloPanel.this._standardFont);
            this._hostText.setBackground(Color.white);
            this._portText.setBackground(Color.white);
            this.add(hostLabel);
            this.add(this._hostText);
            this.add(portLabel);
            this.add(this._portText);
        }

        private String getHost() {
            return this._hostText.getText();
        }

        private String getPort() {
            return this._portText.getText();
        }

        private void setHost(String hostname, boolean visible, boolean changable) {
            this._hostText.setText(hostname);
            this._hostText.setEditable(changable);
        }

        private void setPort(String port, boolean visible, boolean changable) {
            this._portText.setText(port);
            this._portText.setEditable(changable);
        }

        @Override
        public void setEnabled(boolean enable) {
            this._portText.setEnabled(enable);
            this._hostText.setEnabled(enable);
        }
    }

    private class LoginPanel
    extends Panel
    implements ActionListener {
        private static final long serialVersionUID = -5700444988956707265L;
        private String _password = "";
        private TextField _loginText = new TextField("");
        private TextField _passwordText = new TextField("");

        public LoginPanel() {
            KeyValueLayout kvl = new KeyValueLayout();
            kvl.setHgap(10);
            kvl.setVgap(10);
            this.setLayout(kvl);
            Label login = new Label("Login");
            Label password = new Label("Password");
            login.setFont(HelloPanel.this._standardFont);
            password.setFont(HelloPanel.this._standardFont);
            this._loginText.setBackground(Color.white);
            this._passwordText.setBackground(Color.white);
            this._passwordText.setEchoChar('*');
            this._passwordText.addActionListener(this);
            this.add(login);
            this.add(this._loginText);
            this.add(password);
            this.add(this._passwordText);
        }

        @Override
        public synchronized void actionPerformed(ActionEvent event) {
            this._password = this._passwordText.getText();
            this._passwordText.setText("");
        }

        public void addActionListener(ActionListener al) {
            this._passwordText.addActionListener(al);
        }

        private String getUser() {
            return this._loginText.getText();
        }

        private String getPassword() {
            return this._password;
        }

        private void setUser(String user, boolean visible, boolean changable) {
            this._loginText.setText(user);
        }

        private void setPassword(String password, boolean visible, boolean changable) {
            this._passwordText.setText(password);
        }

        @Override
        public void setEnabled(boolean enable) {
            this._loginText.setEnabled(enable);
            this._passwordText.setEnabled(enable);
        }
    }

    private class PictureCanvas
    extends Canvas {
        private static final long serialVersionUID = -7791775854129610704L;

        public PictureCanvas() {
            this.repaint();
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(100, 100);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getSize();
            g.setColor(HelloPanel.this._ourColor);
            g.fillRect(0, 0, d.width - 1, d.height - 1);
            g.setColor(Color.red);
            g.setFont(HelloPanel.this._veryBigFont);
            g.drawString("E", 10, d.height - 10);
            g.drawString("G", 50, d.height - 50);
        }
    }
}

