/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.applets.spy;

import dmg.cells.applets.spy.DomainConnection;
import dmg.cells.applets.spy.FrameArrivable;
import dmg.cells.applets.spy.HistoryTextField;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.services.MessageObjectFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;

class CommandPanel
extends Panel
implements ActionListener,
FrameArrivable {
    private static final long serialVersionUID = -8855448245610647062L;
    private DomainConnection _connection;
    private Font _bigFont = new Font("SansSerif", 2, 18);
    private Font _smallFont = new Font("SansSerif", 3, 14);
    private Font _textFont = new Font("Monospaced", 1, 14);
    private Label _topLabel;
    private Label _classLabel;
    private Label _cellPath;
    private TextArea _outputArea;
    private TextField _requestField;
    private CellInfo _cellInfo;
    private String _cellAddress;
    private boolean _useColor;

    CommandPanel(DomainConnection connection) {
        this._connection = connection;
        boolean bl = this._useColor = System.getProperty("bw") == null;
        if (this._useColor) {
            this.setBackground(Color.orange);
        }
        this.setLayout(new BorderLayout());
        this._topLabel = new Label("<Cell>", 1);
        this._topLabel.setFont(this._bigFont);
        this._classLabel = new Label("<class>");
        this._classLabel.setFont(this._smallFont);
        this._cellPath = new Label("<cellPath>");
        this._cellPath.setFont(this._smallFont);
        this._outputArea = new TextArea();
        this._outputArea.setFont(this._textFont);
        Panel labelPanel = new Panel(new GridLayout(0, 1));
        labelPanel.add(this._topLabel);
        labelPanel.add(this._classLabel);
        labelPanel.add(this._cellPath);
        this._requestField = new HistoryTextField();
        this._requestField.addActionListener(this);
        this.add((Component)labelPanel, "North");
        this.add((Component)this._outputArea, "Center");
        this.add((Component)this._requestField, "South");
    }

    public void clear() {
        this._topLabel.setText("<cellName>");
        this._classLabel.setText("<class>");
        this._cellPath.setText("<cellPath>");
        this._outputArea.setText("");
        this._requestField.setText("");
    }

    @Override
    public Insets getInsets() {
        return new Insets(10, 10, 10, 10);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this._requestField) {
            this.updateCell(this._requestField.getText());
            this._requestField.setText("");
        }
    }

    @Override
    public void frameArrived(MessageObjectFrame frame) {
        Serializable obj = frame.getObject();
        this._outputArea.setText(obj.toString());
    }

    public void showCell(CellInfo info, String address) {
        this._cellInfo = info;
        this._cellAddress = address;
        this.clear();
        this._topLabel.setText(info.getCellName());
        this._classLabel.setText(info.getCellClass());
        this._cellPath.setText(address);
    }

    private void updateCell(String request) {
        if (this._cellAddress == null) {
            return;
        }
        this._connection.send(this._cellAddress, (Serializable)((Object)request), this);
    }
}

