/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.applets.spy;

import dmg.cells.applets.spy.DomainConnectionEvent;
import dmg.cells.applets.spy.DomainConnectionListener;
import dmg.cells.applets.spy.FrameArrivable;
import dmg.cells.nucleus.CellPath;
import dmg.cells.services.MessageObjectFrame;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.Hashtable;

public class DomainConnection
implements Runnable {
    private Socket _socket;
    private Hashtable<MessageObjectFrame, FrameArrivable> _hash;
    private int _counter;
    private ObjectOutputStream _out;
    private ObjectInputStream _in;
    private Thread _listen;
    private String _host;
    private int _port;
    private DomainConnectionListener _listener;
    private boolean _inUse;
    private boolean _ok;

    public DomainConnection(String host, int port) {
        this._host = host;
        this._port = port;
    }

    public void addConnectionListener(DomainConnectionListener listener) {
        this._listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws Exception {
        DomainConnection domainConnection = this;
        synchronized (domainConnection) {
            if (this._inUse) {
                throw new Exception("Still In Use");
            }
            this._inUse = true;
        }
        this._listen = new Thread(this);
        this._listen.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this._socket = new Socket(this._host, this._port);
            this._out = new ObjectOutputStream(this._socket.getOutputStream());
            this._in = new ObjectInputStream(this._socket.getInputStream());
        }
        catch (Exception e) {
            if (this._listener != null) {
                this._listener.connectionFailed(new DomainConnectionEvent(this, "Problem : " + e.toString()));
            }
            DomainConnection domainConnection = this;
            synchronized (domainConnection) {
                this._inUse = false;
                return;
            }
        }
        this._hash = new Hashtable();
        this._counter = 0;
        DomainConnection e = this;
        synchronized (e) {
            this._ok = true;
        }
        if (this._listener != null) {
            this._listener.connectionActivated(new DomainConnectionEvent(this));
        }
        try {
            while (true) {
                Object o;
                if ((o = this._in.readObject()) == null || !(o instanceof MessageObjectFrame)) {
                    throw new Exception("Protocol violation");
                }
                MessageObjectFrame frame = (MessageObjectFrame)o;
                FrameArrivable client = this._hash.get(frame);
                if (client == null) {
                    System.err.println("Client not found");
                    continue;
                }
                client.frameArrived(frame);
            }
        }
        catch (Exception e2) {
            DomainConnection frame = this;
            synchronized (frame) {
                this._ok = false;
            }
            if (this._listener != null) {
                this._listener.connectionDeactivated(new DomainConnectionEvent(this, "Connection Closed : " + e2.toString()));
            }
            try {
                this._out.close();
            }
            catch (IOException ee) {
                // empty catch block
            }
            try {
                this._in.close();
            }
            catch (IOException ee) {
                // empty catch block
            }
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            DomainConnection domainConnection = this;
            synchronized (domainConnection) {
                this._inUse = false;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String cell, Serializable obj, FrameArrivable client) {
        DomainConnection domainConnection = this;
        synchronized (domainConnection) {
            if (!this._ok) {
                return;
            }
        }
        try {
            int next = this._counter++;
            MessageObjectFrame frame = new MessageObjectFrame(next, new CellPath(cell), obj);
            this._hash.put(frame, client);
            this._out.writeObject(frame);
            this._out.flush();
            this._out.reset();
        }
        catch (Exception e) {
            System.err.println("Send Problem : " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DomainConnection domainConnection = this;
        synchronized (domainConnection) {
            if (!this._ok) {
                return;
            }
        }
        try {
            this._out.writeObject("BYE BYE");
            this._out.flush();
            this._out.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

