/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.network;

import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.nucleus.ExceptionEvent;
import dmg.cells.nucleus.KillEvent;
import dmg.cells.nucleus.LastMessageEvent;
import dmg.cells.nucleus.MessageEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.dcache.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleSocket
implements Cell,
Runnable {
    private static final Logger _log = LoggerFactory.getLogger(ExampleSocket.class);
    private CellNucleus _nucleus;
    private Thread _worker;
    private InputStream _input;
    private OutputStream _output;
    private Socket _socket;
    private final Version version = Version.of((Object)this);

    public ExampleSocket(String cellName, Socket socket) {
        this._nucleus = new CellNucleus(this, cellName);
        this._nucleus.export();
        this._worker = this._nucleus.newThread(this, "I/O Engine");
        this._worker.start();
        this._socket = socket;
        try {
            this._input = this._socket.getInputStream();
            this._output = this._socket.getOutputStream();
        }
        catch (Exception nse) {
            _log.info(" Problem in creating streams : " + nse);
            this._nucleus.kill();
        }
        if (this._input == null) {
            _log.info(" Problem _input is null ");
            throw new IllegalArgumentException(" input is null");
        }
        if (this._output == null) {
            _log.info(" Problem _input is null ");
            throw new IllegalArgumentException(" output is null");
        }
    }

    @Override
    public void run() {
        if (Thread.currentThread() == this._worker) {
            byte[] b = new byte[1024];
            try {
                int i;
                while ((i = this._input.read(b)) >= 0 && !Thread.interrupted()) {
                    this._output.write(b, 0, i);
                }
            }
            catch (Exception nse) {
                _log.info(" Problem in i/o : " + nse);
            }
            try {
                this._input.close();
                this._output.close();
                this._socket.close();
            }
            catch (Exception nsea) {
                _log.info(" Problem in i/o : " + nsea);
            }
            this._nucleus.kill();
        }
    }

    @Override
    public String getInfo() {
        return "Example Cell" + this._nucleus.getCellName();
    }

    @Override
    public void messageArrived(MessageEvent me) {
        if (me instanceof LastMessageEvent) {
            return;
        }
        CellMessage msg = me.getMessage();
        _log.info(" CellMessage From   : " + msg.getSourcePath());
        _log.info(" CellMessage To     : " + msg.getDestinationPath());
        _log.info(" CellMessage Object : " + msg.getMessageObject());
        _log.info("");
    }

    @Override
    public void prepareRemoval(KillEvent ce) {
        _log.info(" prepareRemoval " + ce);
        try {
            this._input.close();
            this._output.close();
            this._socket.close();
        }
        catch (Exception nsea) {
            _log.info(" Problem in i/o : " + nsea);
        }
        this._worker.interrupt();
    }

    @Override
    public void exceptionArrived(ExceptionEvent ce) {
        _log.info(" exceptionArrived " + ce);
    }

    @Override
    public CellVersion getCellVersion() {
        return new CellVersion(this.version);
    }
}

