/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.ClassDataProvider;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClassDataProvider0
implements ClassDataProvider {
    private static final Logger _log = LoggerFactory.getLogger(ClassDataProvider0.class);
    private CellNucleus _nucleus;
    private CellPath _cellPath;
    private File _dir;
    private boolean _useSystem;

    ClassDataProvider0(CellNucleus nucleus, CellPath cellPath) {
        this._nucleus = nucleus;
        this._cellPath = cellPath;
    }

    ClassDataProvider0(File dir) {
        this._dir = dir;
    }

    ClassDataProvider0() {
        this._useSystem = true;
    }

    public boolean useSystem() {
        return this._useSystem;
    }

    public String toString() {
        if (this._dir != null) {
            return "CDP0;Directory=" + this._dir;
        }
        if (this._nucleus != null && this._cellPath != null) {
            return "CDP0;Cell=" + this._nucleus.getCellName() + "CellPath=" + this._cellPath;
        }
        return "CDP0;PANIC";
    }

    @Override
    public byte[] getClassData(String className) throws IOException {
        if (this._dir != null) {
            className = className.replace('.', '/') + ".class";
            return this.loadClassDataFile(this._dir, className);
        }
        if (this._nucleus != null && this._cellPath != null) {
            return this.loadClassDataCell(className);
        }
        throw new IOException("PANIC in ClassDataProvider0");
    }

    private byte[] loadClassDataCell(String className) throws IOException {
        CellMessage answer;
        _log.info("getClassData(" + className + ") send to classProvider");
        try {
            answer = this._nucleus.sendAndWait(new CellMessage(this._cellPath, (Serializable)((Object)("get class " + className))), 4000L);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.toString());
        }
        catch (NoRouteToCellException | ExecutionException e) {
            throw new IOException(e.toString(), e);
        }
        if (answer == null) {
            _log.info("getClassData sendAndWait timed out");
            throw new IOException("getClassData sendAndWait timed out");
        }
        Serializable answerObject = answer.getMessageObject();
        if (answerObject == null) {
            throw new IOException("PANIC Message didn't contain data");
        }
        if (!(answerObject instanceof byte[])) {
            _log.info("getClassData sendAndWait got : " + answerObject.toString());
            throw new IOException("Unknown data arrived");
        }
        return (byte[])answerObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassDataFile(File dir, String name) throws IOException {
        _log.info("loadClassData : File=" + name);
        File file = new File(dir, name);
        long length = file.length();
        _log.debug("loadClassData : length=" + length);
        if (length == 0L) {
            throw new IOException("Datafile has zero size");
        }
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        try {
            byte[] data = new byte[(int)length];
            in.read(data);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                _log.error("Close failed: " + e.getMessage());
            }
        }
    }
}

