/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import com.google.common.base.Preconditions;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.Reply;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedReply
implements Reply {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelayedReply.class);
    private CellEndpoint _endpoint;
    private CellMessage _envelope;
    private Serializable _msg;

    @Override
    public synchronized void deliver(CellEndpoint endpoint, CellMessage envelope) {
        this._endpoint = (CellEndpoint)Preconditions.checkNotNull((Object)endpoint);
        this._envelope = (CellMessage)Preconditions.checkNotNull((Object)envelope);
        if (this._msg != null) {
            this.send();
        }
    }

    public synchronized void reply(Serializable msg) {
        this._msg = msg;
        if (this._envelope != null) {
            this.send();
        }
    }

    protected synchronized void send() {
        try {
            this._envelope.setMessageObject(this._msg);
            this._endpoint.sendMessage(this._envelope);
        }
        catch (NoRouteToCellException e) {
            this.onNoRouteToCell(e);
        }
    }

    protected void onNoRouteToCell(NoRouteToCellException e) {
        LOGGER.error("Failed to send reply: " + e.getMessage());
    }
}

