/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.MessageEvent;
import dmg.cells.nucleus.UOID;
import java.io.Serializable;
import org.dcache.util.NetLoggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLogger {
    private static final Logger deliver = LoggerFactory.getLogger((String)"org.dcache.events.cells.deliver");
    private static final Logger send = LoggerFactory.getLogger((String)"org.dcache.events.cells.send");
    private static final Logger queue = LoggerFactory.getLogger((String)"org.dcache.events.cells.queue");
    private static final String DELIVER_BEGIN = "org.dcache.cells.deliver.begin";
    private static final String DELIVER_END = "org.dcache.cells.deliver.end";
    private static final String SEND_BEGIN = "org.dcache.cells.send.begin";
    private static final String SEND_END = "org.dcache.cells.send.end";
    private static final String QUEUE_BEGIN = "org.dcache.cells.queue.begin";
    private static final String QUEUE_END = "org.dcache.cells.queue.end";

    private static String getMessage(CellMessage envelope) {
        Serializable o = envelope.getMessageObject();
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            return "\"" + o + "\"";
        }
        return o.getClass().getSimpleName();
    }

    public static void deliverBegin(CellMessage envelope) {
        if (deliver.isInfoEnabled()) {
            NetLoggerBuilder log = new NetLoggerBuilder(DELIVER_BEGIN);
            log.add("uoid", (Object)envelope.getUOID());
            log.add("lastuoid", (Object)envelope.getLastUOID());
            log.add("session", (Object)envelope.getSession());
            log.add("message", (Object)EventLogger.getMessage(envelope));
            log.add("source", (Object)envelope.getSourcePath());
            log.add("destination", (Object)envelope.getDestinationPath());
            deliver.info(log.toString());
        }
    }

    public static void deliverEnd(Object session, UOID uoid) {
        if (deliver.isInfoEnabled()) {
            NetLoggerBuilder log = new NetLoggerBuilder(DELIVER_END);
            log.add("uoid", (Object)uoid);
            log.add("session", session);
            deliver.info(log.toString());
        }
    }

    public static void sendBegin(CellNucleus nucleus, CellMessage envelope, String mode) {
        if (send.isInfoEnabled() && !envelope.isStreamMode()) {
            CellPath source = envelope.getSourcePath();
            if (source.hops() == 0) {
                source = new CellPath();
                source.add(nucleus.getThisAddress());
            }
            NetLoggerBuilder log = new NetLoggerBuilder(SEND_BEGIN);
            log.add("uoid", (Object)envelope.getUOID());
            log.add("lastuoid", (Object)envelope.getLastUOID());
            log.add("session", (Object)envelope.getSession());
            log.add("mode", (Object)mode);
            log.add("message", (Object)EventLogger.getMessage(envelope));
            log.add("source", (Object)source);
            log.add("destination", (Object)envelope.getDestinationPath());
            send.info(log.toString());
        }
    }

    public static void sendEnd(CellMessage envelope) {
        if (send.isInfoEnabled() && !envelope.isStreamMode()) {
            NetLoggerBuilder log = new NetLoggerBuilder(SEND_END);
            log.add("uoid", (Object)envelope.getUOID());
            log.add("session", (Object)envelope.getSession());
            send.info(log.toString());
        }
    }

    public static void queueBegin(CellEvent event) {
        if (queue.isInfoEnabled() && event.getClass().equals(MessageEvent.class)) {
            CellMessage envelope = ((MessageEvent)event).getMessage();
            NetLoggerBuilder log = new NetLoggerBuilder(QUEUE_BEGIN);
            log.add("uoid", (Object)envelope.getUOID());
            log.add("lastuoid", (Object)envelope.getLastUOID());
            log.add("session", (Object)envelope.getSession());
            log.add("source", (Object)envelope.getSourcePath());
            log.add("destination", (Object)envelope.getDestinationPath());
            queue.info(log.toString());
        }
    }

    public static void queueEnd(CellEvent event) {
        if (queue.isInfoEnabled() && event.getClass().equals(MessageEvent.class)) {
            CellMessage envelope = ((MessageEvent)event).getMessage();
            NetLoggerBuilder log = new NetLoggerBuilder(QUEUE_END);
            log.add("uoid", (Object)envelope.getUOID());
            log.add("session", (Object)envelope.getSession());
            queue.info(log.toString());
        }
    }
}

