/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dcache.util.Args;
import org.slf4j.LoggerFactory;

public class LogbackShell {
    private LoggerContext _context = (LoggerContext)LoggerFactory.getILoggerFactory();
    public static final String hh_log_logger_ls = "[-a]";
    public static final String fh_log_logger_ls = "Lists logger instances. Loggers that inherit all properties are\nnot listed unless the -a option is specified.";
    public static final String hh_log_logger_set = "<logger> OFF|ERROR|WARN|INFO|DEBUG|TRACE|ALL";
    public static final String fh_log_logger_set = "Sets log level of <logger>. Notice that the preferred method to\nadjust log levels in dCache is to manipulate the appender log\nlevels through the 'log set' and 'log reset' commands.";
    public static final String hh_log_logger_reset = "<logger>";
    public static final String fh_log_logger_reset = "Resets the log level of <logger>. The effective log level will be\ninherited from the parent logger. Notice that the preferred method\nto adjust log levels in dCache is to manipulate the appender log\nlevels through the 'log set' and 'log reset' commands.";
    public static final String hh_log_attach = "<logger> <appender>";
    public static final String fh_log_attach = "Attach <logger> to output module <appender>.";
    public static final String hh_log_detach = "<logger> <appender>";
    public static final String fh_log_detach = "Detach <logger> from output module <appender>.";
    public static final String hh_log_get_pattern = "<logger> <appender>";
    public static final String fh_log_get_pattern = "Get encoder pattern for <logger> <appender>.";
    public static final String hh_log_set_pattern = "<logger> <appender> <pattern>";
    public static final String fh_log_set_pattern = "Set encoder pattern to <pattern> for <logger> <appender>.";

    private Logger getLogger(String name) {
        return name.equals("root") ? this._context.getLogger("ROOT") : this._context.getLogger(name);
    }

    private List<Logger> getLoggers() {
        return this._context.getLoggerList();
    }

    private Map<String, Appender<ILoggingEvent>> getAppenders() {
        HashMap<String, Appender<ILoggingEvent>> appenders = new HashMap<String, Appender<ILoggingEvent>>();
        for (Logger logger : this.getLoggers()) {
            Iterator i = logger.iteratorForAppenders();
            while (i.hasNext()) {
                Appender appender = (Appender)i.next();
                appenders.put(appender.getName(), (Appender<ILoggingEvent>)appender);
            }
        }
        return appenders;
    }

    private List<Appender<ILoggingEvent>> getAppenders(Logger logger) {
        Iterator appenders = logger.iteratorForAppenders();
        ArrayList<Appender<ILoggingEvent>> result = new ArrayList<Appender<ILoggingEvent>>();
        while (appenders.hasNext()) {
            result.add((Appender<ILoggingEvent>)appenders.next());
        }
        return result;
    }

    private List<String> getNames(List<Appender<ILoggingEvent>> appenders) {
        ArrayList<String> result = new ArrayList<String>(appenders.size());
        for (Appender<ILoggingEvent> appender : appenders) {
            result.add(appender.getName());
        }
        return result;
    }

    private String toString(Level level) {
        return level == null ? "" : level.toString();
    }

    public String ac_log_logger_ls(Args args) {
        String format = "%-5s %-30s %s\n";
        boolean all = args.hasOption("a");
        Formatter f = new Formatter();
        f.format("%-5s %-30s %s\n", "Level", "Appenders", "Logger");
        f.format("%-5s %-30s %s\n", "-----", "---------", "------");
        for (Logger logger : this.getLoggers()) {
            List<Appender<ILoggingEvent>> appenders = this.getAppenders(logger);
            boolean hasAppenders = !appenders.isEmpty();
            boolean isEndOfRoad = !logger.isAdditive();
            boolean hasLevel = logger.getLevel() != null;
            boolean isRoot = logger.getName().equals("ROOT");
            if (!all && !hasAppenders && !isEndOfRoad && !hasLevel && !isRoot) continue;
            f.format("%-5s %-30s %s\n", this.toString(logger.getLevel()), this.getNames(appenders), logger.getName());
        }
        return f.toString();
    }

    public String ac_log_logger_set_$_2(Args args) {
        String name = args.argv(0);
        Level level = Level.valueOf((String)args.argv(1));
        Logger logger = this.getLogger(name);
        if (logger == null) {
            throw new IllegalArgumentException("Logger not found: " + name);
        }
        logger.setLevel(level);
        return "Log level of " + name + " set to " + level;
    }

    public String ac_log_logger_reset_$_1(Args args) {
        String name = args.argv(0);
        Logger logger = this.getLogger(name);
        if (logger == null) {
            throw new IllegalArgumentException("Logger not found: " + name);
        }
        logger.setLevel(null);
        return "Log level of " + name + " was reset";
    }

    public String ac_log_attach_$_2(Args args) {
        String name = args.argv(0);
        String appender = args.argv(1);
        Logger logger = this.getLogger(name);
        if (logger == null) {
            throw new IllegalArgumentException("Logger not found: " + name);
        }
        Appender<ILoggingEvent> app = this.getAppenders().get(appender);
        if (app == null) {
            throw new IllegalArgumentException("Appender not found: " + appender);
        }
        logger.addAppender(app);
        return name + " attached to " + appender;
    }

    public String ac_log_detach_$_2(Args args) {
        String name = args.argv(0);
        String appender = args.argv(1);
        Logger logger = this.getLogger(name);
        if (logger == null) {
            throw new IllegalArgumentException("Logger not found: " + name);
        }
        logger.detachAppender(appender);
        return name + " detached from " + appender;
    }

    public String ac_log_get_pattern_$_2(Args args) {
        Encoder encoder;
        String loggerName = args.argv(0);
        String appenderName = args.argv(1);
        Logger logger = this.getLogger(loggerName);
        if (logger == null) {
            throw new IllegalArgumentException("Logger not found: " + loggerName);
        }
        Appender appender = logger.getAppender(appenderName);
        if (appender == null) {
            throw new IllegalArgumentException("Appender not found: " + appender);
        }
        if (appender instanceof ConsoleAppender) {
            encoder = ((ConsoleAppender)appender).getEncoder();
        } else if (appender instanceof FileAppender) {
            encoder = ((FileAppender)appender).getEncoder();
        } else {
            throw new IllegalArgumentException("Appender " + appenderName + " does not support encoders.");
        }
        if (!(encoder instanceof PatternLayoutEncoder)) {
            throw new IllegalArgumentException("Appender " + appenderName + " does not provide a pattern encoder.");
        }
        PatternLayoutEncoder patternLayoutEncoder = (PatternLayoutEncoder)encoder;
        return "pattern of appender " + appenderName + " is " + patternLayoutEncoder.getPattern();
    }

    public String ac_log_set_pattern_$_3(Args args) {
        String loggerName = args.argv(0);
        String appenderName = args.argv(1);
        String pattern = args.argv(2);
        Logger logger = this.getLogger(loggerName);
        if (logger == null) {
            throw new IllegalArgumentException("Logger not found: " + loggerName);
        }
        Appender appender = logger.getAppender(appenderName);
        if (appender == null) {
            throw new IllegalArgumentException("Appender not found: " + appender);
        }
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)this._context);
        encoder.setPattern(pattern);
        encoder.start();
        if (appender instanceof ConsoleAppender) {
            ((ConsoleAppender)appender).setEncoder((Encoder)encoder);
        } else if (appender instanceof FileAppender) {
            ((FileAppender)appender).setEncoder((Encoder)encoder);
        } else {
            throw new IllegalArgumentException("Appender " + appenderName + " does not support encoders");
        }
        return "pattern of appender " + loggerName + "." + appenderName + " set to " + encoder.getPattern();
    }
}

