/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services;

import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.nucleus.ExceptionEvent;
import dmg.cells.nucleus.KillEvent;
import dmg.cells.nucleus.LastMessageEvent;
import dmg.cells.nucleus.MessageEvent;
import dmg.util.Gate;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Vector;
import org.dcache.util.Args;
import org.dcache.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapStore
implements Cell {
    private static final Logger _log = LoggerFactory.getLogger(BootstrapStore.class);
    private Gate _finalGate = new Gate(false);
    private String _storeBase;
    private CellNucleus _nucleus;
    private int _requests;
    private int _answeredRequests;
    private final Version version = Version.of((Object)this);

    public BootstrapStore(String cellName, String arg) {
        Args args = new Args((CharSequence)arg);
        if (args.argc() < 1) {
            throw new IllegalArgumentException("Usage : ... <storebase>");
        }
        this._storeBase = args.argv(0);
        this._nucleus = new CellNucleus(this, cellName);
    }

    public String toString() {
        return this._nucleus.getCellDomainName() + " StoreBase=" + this._storeBase + ";R=" + this._requests + ";AR=" + this._answeredRequests;
    }

    @Override
    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(" StoreBase         : ").append(this._storeBase).append("\n");
        sb.append(" Requests          : ").append(this._requests).append("\n");
        sb.append(" Answered Requests : ").append(this._answeredRequests).append("\n");
        return sb.toString();
    }

    @Override
    public void messageArrived(MessageEvent me) {
        if (me instanceof LastMessageEvent) {
            this._finalGate.open();
        } else {
            CellMessage msg = me.getMessage();
            if (msg.isFinalDestination()) {
                Serializable obj = msg.getMessageObject();
                _log.info("Got Object : " + obj.toString());
                ++this._requests;
                if (obj instanceof String) {
                    String command = (String)((Object)obj);
                    Args args = new Args((CharSequence)command);
                    if (args.argc() < 2) {
                        return;
                    }
                    try {
                        String[] answer = this.readConfigDB(args.argv(1));
                        if (answer == null) {
                            return;
                        }
                        msg.setMessageObject((Serializable)answer);
                        msg.revertDirection();
                        this._nucleus.sendMessage(msg, true, true);
                        ++this._answeredRequests;
                    }
                    catch (Exception mse) {
                        _log.info("messageArrived : Problem with " + args.argv(1) + " -> " + mse);
                    }
                }
            }
        }
    }

    public String[] readConfigDB(String name) throws Exception {
        String str;
        String filename = this._storeBase + "/" + name + ".conf";
        BufferedReader in = new BufferedReader(new FileReader(filename));
        Vector<String> vec = new Vector<String>();
        while ((str = in.readLine()) != null) {
            vec.addElement(str);
        }
        in.close();
        int vecSize = vec.size();
        String[] sa = new String[vecSize];
        for (int i = 0; i < vecSize; ++i) {
            sa[i] = (String)vec.elementAt(i);
        }
        return sa;
    }

    @Override
    public void prepareRemoval(KillEvent ce) {
        this._finalGate.check();
    }

    @Override
    public void exceptionArrived(ExceptionEvent ce) {
        _log.info(" exceptionArrived " + ce);
    }

    @Override
    public CellVersion getCellVersion() {
        return new CellVersion(this.version);
    }
}

