/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.gui;

import dmg.cells.applets.login.DomainConnection;
import dmg.cells.applets.login.DomainConnectionListener;
import dmg.cells.applets.login.DomainEventListener;
import dmg.cells.applets.login.DomainObjectFrame;
import dmg.cells.services.gui.JLoginPanel;
import dmg.protocols.ssh.SshAuthMethod;
import dmg.protocols.ssh.SshAuthPassword;
import dmg.protocols.ssh.SshAuthenticationException;
import dmg.protocols.ssh.SshClientAuthentication;
import dmg.protocols.ssh.SshRsaKey;
import dmg.protocols.ssh.SshSharedKey;
import dmg.protocols.ssh.SshStreamEngine;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class JSshLoginPanel
extends JLoginPanel
implements SshClientAuthentication {
    private static final long serialVersionUID = -5232110128335815665L;
    private final SshDomainConnection _connection = new SshDomainConnection();
    private ObjectOutputStream _objOut;
    private ObjectInputStream _objIn;
    private Socket _socket;
    private int _requestCounter;

    public DomainConnection getDomainConnection() {
        return this._connection;
    }

    public JSshLoginPanel() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JSshLoginPanel.this.setMessage("Calling ConnectionEngine");
                new Thread(new ConnectionThread()).start();
            }
        });
    }

    @Override
    public boolean isHostKey(InetAddress host, SshRsaKey keyModulus) {
        return true;
    }

    @Override
    public String getUser() {
        this._requestCounter = 0;
        String loginName = this.getLogin();
        System.out.println("getUser : " + loginName);
        return loginName;
    }

    @Override
    public SshSharedKey getSharedKey(InetAddress host) {
        return null;
    }

    @Override
    public SshAuthMethod getAuthMethod() {
        String password = this.getPassword();
        System.out.println("getAuthMethod(" + this._requestCounter + ") " + password);
        return this._requestCounter++ > 2 ? null : new SshAuthPassword(password);
    }

    public class SshDomainConnection
    implements DomainConnection {
        private Hashtable<DomainObjectFrame, DomainConnectionListener> _packetHash = new Hashtable();
        private final Object _ioLock = new Object();
        private int _ioCounter = 100;
        private Vector<DomainEventListener> _listener = new Vector();
        private boolean _connected;

        @Override
        public String getAuthenticatedUser() {
            return JSshLoginPanel.this.getLogin();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int sendObject(Serializable obj, DomainConnectionListener listener, int id) throws IOException {
            System.out.println("Sending : " + obj);
            Object object = this._ioLock;
            synchronized (object) {
                if (!this._connected) {
                    throw new IOException("Not connected");
                }
                DomainObjectFrame frame = new DomainObjectFrame(obj, ++this._ioCounter, id);
                JSshLoginPanel.this._objOut.writeObject(frame);
                JSshLoginPanel.this._objOut.reset();
                this._packetHash.put(frame, listener);
                return this._ioCounter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int sendObject(String destination, Serializable obj, DomainConnectionListener listener, int id) throws IOException {
            System.out.println("Sending : " + obj);
            Object object = this._ioLock;
            synchronized (object) {
                if (!this._connected) {
                    throw new IOException("Not connected");
                }
                DomainObjectFrame frame = new DomainObjectFrame(destination, obj, ++this._ioCounter, id);
                JSshLoginPanel.this._objOut.writeObject(frame);
                JSshLoginPanel.this._objOut.reset();
                this._packetHash.put(frame, listener);
                return this._ioCounter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addDomainEventListener(DomainEventListener listener) {
            Object object = this._ioLock;
            synchronized (object) {
                this._listener.addElement(listener);
                if (this._connected) {
                    try {
                        listener.connectionOpened(this);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeDomainEventListener(DomainEventListener listener) {
            Object object = this._ioLock;
            synchronized (object) {
                this._listener.removeElement(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void informListenersOpened() {
            Object object = this._ioLock;
            synchronized (object) {
                this._connected = true;
                for (DomainEventListener listener : new ArrayList<DomainEventListener>(this._listener)) {
                    try {
                        listener.connectionOpened(this);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void informListenersClosed() {
            Object object = this._ioLock;
            synchronized (object) {
                this._connected = false;
                for (DomainEventListener listener : new ArrayList<DomainEventListener>(this._listener)) {
                    try {
                        listener.connectionClosed(this);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }

    private class ConnectionThread
    implements Runnable {
        private ConnectionThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.runConnectionProtocol();
                JSshLoginPanel.this._connection.informListenersOpened();
            }
            catch (SshAuthenticationException ae) {
                JSshLoginPanel.this.setErrorMessage("Login Failed");
                JSshLoginPanel.this.displayLoginPanel();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                JSshLoginPanel.this.setErrorMessage("Login Failed (" + e + ")");
                JSshLoginPanel.this.displayLoginPanel();
                return;
            }
            JSshLoginPanel.this.setErrorMessage("");
            JSshLoginPanel.this.setMessage("Connected");
            try {
                this.runReceiver();
            }
            catch (Exception ee) {
                ee.printStackTrace();
                JSshLoginPanel.this.setErrorMessage("Connection Broken");
            }
            finally {
                try {
                    JSshLoginPanel.this._socket.close();
                }
                catch (IOException iOException) {}
                JSshLoginPanel.this._connection.informListenersClosed();
                JSshLoginPanel.this.displayLoginPanel();
            }
        }

        private void runConnectionProtocol() throws Exception {
            String check;
            JSshLoginPanel.this.setMessage("Connecting");
            int port = Integer.parseInt(JSshLoginPanel.this.getPortnumber());
            JSshLoginPanel.this._socket = new Socket(JSshLoginPanel.this.getHostname(), port);
            SshStreamEngine engine = new SshStreamEngine(JSshLoginPanel.this._socket, JSshLoginPanel.this);
            PrintWriter writer = new PrintWriter(engine.getWriter());
            BufferedReader reader = new BufferedReader(engine.getReader());
            JSshLoginPanel.this.setMessage("Requesting Binary Connection");
            writer.println("$BINARY$");
            writer.flush();
            while (!(check = reader.readLine()).equals("$BINARY$")) {
            }
            JSshLoginPanel.this.setMessage("Binary acknowledged");
            JSshLoginPanel.this._objOut = new ObjectOutputStream(engine.getOutputStream());
            JSshLoginPanel.this._objIn = new ObjectInputStream(engine.getInputStream());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runReceiver() throws Exception {
            Object obj;
            while ((obj = JSshLoginPanel.this._objIn.readObject()) != null) {
                DomainConnectionListener listener;
                DomainObjectFrame frame;
                System.out.println("Received : " + obj);
                if (!(obj instanceof DomainObjectFrame)) continue;
                Object object = JSshLoginPanel.this._connection._ioLock;
                synchronized (object) {
                    frame = (DomainObjectFrame)obj;
                    listener = (DomainConnectionListener)JSshLoginPanel.this._connection._packetHash.remove(frame);
                    if (listener == null) {
                        System.err.println("Message without receiver : " + frame);
                        continue;
                    }
                }
                try {
                    System.out.println("Delivering : " + frame.getPayload());
                    listener.domainAnswerArrived(frame.getPayload(), frame.getSubId());
                }
                catch (Exception eee) {
                    System.out.println("Problem in domainAnswerArrived : " + eee);
                }
            }
        }
    }
}

