/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractService;
import dmg.cells.nucleus.Cell;
import dmg.cells.services.login.LoginCellFactory;
import dmg.util.StreamEngine;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.dcache.util.Args;

public class LegacyWithArgsLoginCellFactory
extends AbstractService
implements LoginCellFactory {
    private final Constructor<? extends Cell> _loginConstructor;
    private final Args _args;
    private final String _cellName;

    public LegacyWithArgsLoginCellFactory(Constructor<? extends Cell> loginConstructor, Args args, String cellName) {
        this._cellName = (String)Preconditions.checkNotNull((Object)cellName);
        this._args = (Args)Preconditions.checkNotNull((Object)args);
        this._loginConstructor = (Constructor)Preconditions.checkNotNull(loginConstructor);
    }

    @Override
    public Cell newCell(StreamEngine engine, String userName) throws InvocationTargetException {
        try {
            return this._loginConstructor.newInstance(this._cellName + "-" + userName + "*", engine, new Args(this._args));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to instantiate login cell: " + this.getName(), e);
        }
    }

    @Override
    public String getName() {
        return this._loginConstructor.getDeclaringClass().getName();
    }

    protected void doStart() {
        this.notifyStarted();
    }

    protected void doStop() {
        this.notifyStopped();
    }
}

