/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import com.google.common.base.Throwables;
import dmg.cells.nucleus.AbstractCellComponent;
import dmg.cells.nucleus.CellCommandListener;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.login.LoginBrokerInfo;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.dcache.util.Args;
import org.dcache.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginBrokerHandler
extends AbstractCellComponent
implements CellCommandListener {
    private static final Logger _log = LoggerFactory.getLogger(LoginBrokerHandler.class);
    private static final long EAGER_UPDATE_TIME = TimeUnit.SECONDS.toMillis(1L);
    private String[] _loginBrokers;
    private String _protocolFamily;
    private String _protocolVersion;
    private String _protocolEngine;
    private long _brokerUpdateTime = TimeUnit.MINUTES.toMillis(5L);
    private TimeUnit _brokerUpdateTimeUnit = TimeUnit.MILLISECONDS;
    private double _brokerUpdateThreshold = 0.1;
    private UpdateMode _currentUpdateMode = UpdateMode.NORMAL;
    private LoadProvider _load = new FixedLoad(0.0);
    private String[] _hosts;
    private int _port;
    private ScheduledExecutorService _executor;
    private ScheduledFuture<?> _task;
    private String _root;
    public static final String hh_lb_set_update = "<updateTime/sec>";
    public static final String hh_lb_set_threshold = "<threshold>";

    public LoginBrokerHandler() {
        try {
            this.setAddresses(NetworkUtils.getLocalAddressesV4());
        }
        catch (SocketException e) {
            _log.error("Failed to obtain the IP addresses of this host: " + e.getMessage());
        }
    }

    public synchronized String ac_lb_set_update_$_1(Args args) {
        long time = Long.parseLong(args.argv(0));
        if (time < 2L) {
            throw new IllegalArgumentException("Update time out of range");
        }
        this._brokerUpdateTime = time;
        this._brokerUpdateTimeUnit = TimeUnit.SECONDS;
        this.rescheduleTask();
        return "";
    }

    public synchronized String ac_lb_set_threshold_$_1(Args args) {
        this.setUpdateThreshold(Double.parseDouble(args.argv(0)));
        return "";
    }

    protected LoginBrokerInfo newInfo(String cell, String domain, String protocolFamily, String protocolVersion, String protocolEngine, String root) {
        return new LoginBrokerInfo(cell, domain, protocolFamily, protocolVersion, protocolEngine, root);
    }

    private synchronized void sendUpdate() {
        if (this._loginBrokers == null || this._hosts == null) {
            return;
        }
        LoginBrokerInfo info = this.newInfo(this.getCellName(), this.getCellDomainName(), this._protocolFamily, this._protocolVersion, this._protocolEngine, this._root);
        info.setUpdateTime(this._brokerUpdateTimeUnit.toMillis(this._brokerUpdateTime));
        info.setHosts(this._hosts);
        info.setPort(this._port);
        info.setLoad(this._load.getLoad());
        UpdateMode newUpdateMode = UpdateMode.NORMAL;
        for (String loginBroker : this._loginBrokers) {
            try {
                this.sendMessage(new CellMessage(new CellPath(loginBroker), info));
            }
            catch (NoRouteToCellException e) {
                _log.warn("Failed to send update to {}", (Object)loginBroker);
                newUpdateMode = UpdateMode.EAGER;
            }
        }
        if (this._currentUpdateMode != newUpdateMode) {
            this._currentUpdateMode = newUpdateMode;
            this.rescheduleTask();
        }
    }

    @Override
    public synchronized void getInfo(PrintWriter pw) {
        if (this._loginBrokers == null || this._task == null) {
            pw.println("    Login Broker : DISABLED");
            return;
        }
        pw.println("    LoginBroker      : " + Arrays.toString(this._loginBrokers));
        pw.println("    Protocol Family  : " + this._protocolFamily);
        pw.println("    Protocol Version : " + this._protocolVersion);
        pw.println("    Update Time      : " + this._brokerUpdateTime + " " + (Object)((Object)this._brokerUpdateTimeUnit));
        pw.println("    Update Threshold : " + (int)(this._brokerUpdateThreshold * 100.0) + " %");
    }

    public synchronized void setAddresses(List<InetAddress> addresses) {
        this._hosts = new String[addresses.size()];
        int nextExternalIfIndex = 0;
        int nextInternalIfIndex = addresses.size() - 1;
        for (InetAddress addr : addresses) {
            String host = addr.getCanonicalHostName();
            if (!(addr.isLinkLocalAddress() || addr.isLoopbackAddress() || addr.isSiteLocalAddress() || addr.isMulticastAddress())) {
                this._hosts[nextExternalIfIndex++] = host;
                continue;
            }
            this._hosts[nextInternalIfIndex--] = host;
        }
        this.rescheduleTask();
    }

    public synchronized void setAddress(String host) throws SocketException, UnknownHostException {
        if (host == null) {
            this.setAddresses(NetworkUtils.getLocalAddressesV4());
        } else {
            InetAddress address = InetAddress.getByName(host);
            if (address.isAnyLocalAddress()) {
                this.setAddresses(NetworkUtils.getLocalAddressesV4());
            } else {
                this.setAddresses(Collections.singletonList(address));
            }
        }
    }

    public synchronized void setPort(int port) {
        this._port = port;
        this.rescheduleTask();
    }

    public synchronized void setLoad(int children, int maxChildren) {
        double load = maxChildren > 0 ? (double)children / (double)maxChildren : 0.0;
        this.setLoad(new FixedLoad(load));
    }

    public synchronized void setLoad(LoadProvider load) {
        double diff = Math.abs(this._load.getLoad() - load.getLoad());
        if (diff > this._brokerUpdateThreshold) {
            this.rescheduleTask();
        }
        this._load = load;
    }

    public synchronized void setLoginBrokers(String[] loginBrokers) {
        this._loginBrokers = loginBrokers;
        this.rescheduleTask();
    }

    public synchronized String[] getLoginBrokers() {
        return Arrays.copyOf(this._loginBrokers, this._loginBrokers.length);
    }

    public synchronized void setProtocolFamily(String protocolFamily) {
        this._protocolFamily = protocolFamily;
        this.rescheduleTask();
    }

    public synchronized String getProtocolFamily() {
        return this._protocolFamily;
    }

    public synchronized void setProtocolVersion(String protocolVersion) {
        this._protocolVersion = protocolVersion;
        this.rescheduleTask();
    }

    public synchronized String getProtocolVersion() {
        return this._protocolVersion;
    }

    public synchronized void setProtocolEngine(String protocolEngine) {
        this._protocolEngine = protocolEngine;
        this.rescheduleTask();
    }

    public synchronized String getProtocolEngine() {
        return this._protocolEngine;
    }

    public synchronized void setUpdateThreshold(double threshold) {
        this._brokerUpdateThreshold = threshold;
    }

    public synchronized double getUpdateThreshold() {
        return this._brokerUpdateThreshold;
    }

    public synchronized void setUpdateTime(long time) {
        this._brokerUpdateTime = time;
    }

    public synchronized long getUpdateTime() {
        return this._brokerUpdateTime;
    }

    public synchronized void setUpdateTimeUnit(TimeUnit unit) {
        this._brokerUpdateTimeUnit = unit;
        this.rescheduleTask();
    }

    public synchronized TimeUnit getUpdateTimeUnit() {
        return this._brokerUpdateTimeUnit;
    }

    public synchronized void setRoot(String root) {
        this._root = root;
    }

    public synchronized void setExecutor(ScheduledExecutorService executor) {
        this._executor = executor;
        this.rescheduleTask();
    }

    public synchronized void start() {
        this.scheduleTask();
    }

    public synchronized void stop() {
        if (this._task != null) {
            this._task.cancel(false);
            this._task = null;
        }
    }

    private void rescheduleTask() {
        if (this._task != null) {
            this._task.cancel(false);
            this.scheduleTask();
        }
    }

    private void scheduleTask() {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                try {
                    LoginBrokerHandler.this.sendUpdate();
                }
                catch (Throwable e) {
                    Thread thisThread = Thread.currentThread();
                    Thread.UncaughtExceptionHandler ueh = thisThread.getUncaughtExceptionHandler();
                    ueh.uncaughtException(thisThread, e);
                    Throwables.propagateIfPossible((Throwable)e);
                }
            }
        };
        switch (this._currentUpdateMode) {
            case EAGER: {
                this._task = this._executor.scheduleWithFixedDelay(command, EAGER_UPDATE_TIME, EAGER_UPDATE_TIME, TimeUnit.MILLISECONDS);
                break;
            }
            case NORMAL: {
                this._task = this._executor.scheduleWithFixedDelay(command, 0L, this._brokerUpdateTime, this._brokerUpdateTimeUnit);
            }
        }
    }

    private static class FixedLoad
    implements LoadProvider {
        private double _load;

        public FixedLoad(double load) {
            this._load = load;
        }

        @Override
        public double getLoad() {
            return this._load;
        }
    }

    public static interface LoadProvider {
        public double getLoad();
    }

    static enum UpdateMode {
        EAGER,
        NORMAL;

    }
}

