/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import java.io.Serializable;

public class LoginBrokerInfo
implements Serializable {
    private static final long serialVersionUID = 4077557054990432737L;
    private String _cellName;
    private String _domainName;
    private String _protocolFamily;
    private String _protocolVersion;
    private String _protocolEngine;
    private String _root;
    private String[] _hosts = new String[0];
    private int _port;
    private double _load;
    private long _update = -1L;

    public LoginBrokerInfo(String cellName, String domainName, String protocolFamily, String protocolVersion, String protocolEngine, String root) {
        this._cellName = cellName;
        this._domainName = domainName;
        this._protocolFamily = protocolFamily;
        this._protocolVersion = protocolVersion;
        this._protocolEngine = protocolEngine;
        this._root = root;
    }

    public String getHost() {
        return this._hosts.length == 0 ? "" : this._hosts[0];
    }

    public String[] getHosts() {
        return this._hosts;
    }

    public int getPort() {
        return this._port;
    }

    public String getCellName() {
        return this._cellName;
    }

    public String getDomainName() {
        return this._domainName;
    }

    public String getProtocolFamily() {
        return this._protocolFamily;
    }

    public String getProtocolVersion() {
        return this._protocolVersion;
    }

    public String getProtocolEngine() {
        return this._protocolEngine;
    }

    public String getRoot() {
        return this._root;
    }

    public double getLoad() {
        return this._load;
    }

    public long getUpdateTime() {
        return this._update;
    }

    public void setUpdateTime(long update) {
        this._update = update;
    }

    public void setLoad(double load) {
        this._load = load;
    }

    public void setHosts(String[] hosts) {
        this._hosts = hosts;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public String getIdentifier() {
        return this._cellName + "@" + this._domainName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LoginBrokerInfo)) {
            return false;
        }
        LoginBrokerInfo info = (LoginBrokerInfo)obj;
        return this._cellName.equals(info._cellName) && this._domainName.equals(info._domainName);
    }

    public int hashCode() {
        return (this._cellName + "@" + this._domainName).hashCode();
    }

    public String toString() {
        int pos = this._protocolEngine.lastIndexOf(46);
        String engine = pos < 0 || pos == this._protocolEngine.length() - 1 ? this._protocolEngine : this._protocolEngine.substring(pos + 1);
        StringBuilder sb = new StringBuilder();
        sb.append(this._cellName).append("@").append(this._domainName).append(";");
        sb.append(engine).append(";");
        sb.append("{").append(this._protocolFamily).append(",").append(this._protocolVersion).append("};");
        sb.append("[");
        for (int i = 0; i < this._hosts.length - 1; ++i) {
            sb.append(this._hosts[i]).append(",");
        }
        if (this._hosts.length > 0) {
            sb.append(this._hosts[this._hosts.length - 1]);
        }
        sb.append(":").append(this._port).append("]").append(";");
        sb.append("<");
        sb.append((int)(this._load * 100.0)).append(",");
        sb.append(this._update).append(">;");
        return sb.toString();
    }
}

