/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import dmg.cells.services.login.LoginCellFactory;
import dmg.cells.services.login.LoginCellProvider;
import java.util.ServiceLoader;
import org.dcache.util.Args;

public class LoginCellFactoryBuilder {
    private static final ServiceLoader<LoginCellProvider> PROVIDERS = ServiceLoader.load(LoginCellProvider.class);
    private String name;
    private Args args;
    private String loginManagerName;

    public LoginCellFactoryBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public LoginCellFactoryBuilder setArgs(Args args) {
        this.args = args;
        return this;
    }

    public LoginCellFactoryBuilder setLoginManagerName(String loginManagerName) {
        this.loginManagerName = loginManagerName;
        return this;
    }

    public LoginCellFactory build() {
        LoginCellProvider bestProvider = (LoginCellProvider)Ordering.natural().onResultOf(LoginCellFactoryBuilder.priorityFor(this.name)).max(PROVIDERS);
        if (bestProvider.getPriority(this.name) == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("No login cell provider found for " + this.name);
        }
        return bestProvider.createFactory(this.name, this.args, this.loginManagerName);
    }

    private static Function<LoginCellProvider, Integer> priorityFor(final String name) {
        return new Function<LoginCellProvider, Integer>(){

            public Integer apply(LoginCellProvider provider) {
                return provider.getPriority(name);
            }
        };
    }
}

