/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellEventListener;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.login.LoginBrokerHandler;
import dmg.cells.services.login.LoginCellFactory;
import dmg.cells.services.login.LoginCellFactoryBuilder;
import dmg.cells.services.login.LoginManagerChildrenInfo;
import dmg.cells.services.login.SshSAuth_A;
import dmg.cells.services.login.StreamEngineFactory;
import dmg.cells.services.login.TelnetSAuth_A;
import dmg.util.KeepAliveListener;
import dmg.util.StreamEngine;
import dmg.util.UserValidatable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.dcache.util.Args;
import org.dcache.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginManager
extends CellAdapter
implements UserValidatable {
    private static final Object DEAD_CELL = new Object();
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginManager.class);
    private static final Class<?>[] AUTH_CON_SIGNATURE = new Class[]{CellNucleus.class, Args.class};
    private final CellNucleus _nucleus;
    private final Args _args;
    private final ListenThread _listenThread;
    private final String _locationManager;
    private final AtomicInteger _connectionDeniedCounter = new AtomicInteger();
    private final AtomicInteger _loginCounter = new AtomicInteger();
    private final AtomicInteger _loginFailures = new AtomicInteger();
    private final CellVersion _version;
    private final Constructor<?> _authConstructor;
    private final ScheduledExecutorService _scheduledExecutor;
    private final ConcurrentMap<String, Object> _children = new ConcurrentHashMap<String, Object>();
    private final CellPath _authenticator;
    private final KeepAliveThread _keepAlive;
    private final LoginBrokerHandler _loginBrokerHandler;
    private final String _protocol;
    private final Class<?> _authClass;
    private final LoginCellFactory _loginCellFactory;
    private volatile boolean _sending;
    private volatile int _maxLogin = -1;
    public static final String hh_get_children = "[-binary]";
    public static final String hh_set_keepalive = "<keepAliveValue/seconds>";
    public static final String hh_set_max_logins = "<maxNumberOfLogins>|-1";

    public LoginManager(String name, String argString) throws Exception {
        super(name, argString, false);
        this._nucleus = this.getNucleus();
        this._args = this.getArgs();
        try {
            Constructor<?> authConstructor;
            if (this._args.argc() < 2) {
                throw new IllegalArgumentException("USAGE : ... <listenPort> <loginCell> [-prot=ssh|telnet|raw] [-auth=<authCell>] [-maxLogin=<n>|-1] [-keepAlive=<seconds>] [-acceptErrorWait=<msecs>] [args givenToLoginClass]");
            }
            int listenPort = Integer.parseInt(this._args.argv(0));
            String loginCell = this._args.argv(1);
            Args childArgs = new Args((CharSequence)argString.replaceFirst("(^|\\s)-export(=true|=false)?($|\\s)", " "));
            childArgs.shift();
            childArgs.shift();
            this._protocol = LoginManager.checkProtocol(this._args.getOpt("prot"));
            LOGGER.info("Using protocol : {}", (Object)this._protocol);
            this._authenticator = new CellPath(this._args.getOption("authenticator", "pam"));
            this._authClass = LoginManager.toAuthClass(this._args.getOpt("auth"), this._protocol);
            if (this._authClass != null) {
                authConstructor = this._authClass.getConstructor(AUTH_CON_SIGNATURE);
                LOGGER.trace("Using authentication constructor: {}", authConstructor);
            } else {
                authConstructor = null;
                LOGGER.trace("No authentication used");
            }
            this._authConstructor = authConstructor;
            String maxLogin = this._args.getOpt("maxLogin");
            if (maxLogin != null) {
                try {
                    this._maxLogin = Integer.parseInt(maxLogin);
                }
                catch (NumberFormatException ee) {
                    // empty catch block
                }
            }
            if (this._maxLogin < 0) {
                LOGGER.info("Maximum login feature disabled");
            } else {
                this._nucleus.addCellEventListener(new LoginEventListener());
                LOGGER.info("Maximum logins set to: {}", (Object)this._maxLogin);
            }
            long keepAlive = TimeUnit.SECONDS.toMillis(this._args.getLongOption("keepAlive", 0L));
            LOGGER.info("Keep alive set to {} ms", (Object)keepAlive);
            this._keepAlive = new KeepAliveThread(keepAlive);
            this._locationManager = this._args.getOpt("lm");
            this._loginCellFactory = new LoginCellFactoryBuilder().setName(loginCell).setLoginManagerName(this.getCellName()).setArgs(childArgs).build();
            this._version = new CellVersion(Version.of((Object)this._loginCellFactory));
            this._scheduledExecutor = Executors.newSingleThreadScheduledExecutor(this._nucleus);
            String loginBroker = this._args.getOpt("loginBroker");
            if (loginBroker != null) {
                Iterable loginBrokers = Splitter.on((String)",").omitEmptyStrings().split((CharSequence)loginBroker);
                this._loginBrokerHandler = new LoginBrokerHandler();
                this._loginBrokerHandler.beforeSetup();
                this._loginBrokerHandler.setExecutor(this._scheduledExecutor);
                this._loginBrokerHandler.setLoginBrokers((String[])Iterables.toArray((Iterable)loginBrokers, String.class));
                this._loginBrokerHandler.setCellEndpoint(this);
                this._loginBrokerHandler.setProtocolEngine(this._loginCellFactory.getName());
                this._loginBrokerHandler.setProtocolFamily(this._args.getOption("protocolFamily", this._protocol));
                this._loginBrokerHandler.setProtocolVersion(this._args.getOption("protocolVersion", "1.0"));
                this._loginBrokerHandler.setUpdateTime(this._args.getLongOption("brokerUpdateTime"));
                this._loginBrokerHandler.setUpdateTimeUnit(TimeUnit.valueOf(this._args.getOption("brokerUpdateTimeUnit")));
                this._loginBrokerHandler.setUpdateThreshold(this._args.getDoubleOption("brokerUpdateOffset"));
                this._loginBrokerHandler.setRoot(Strings.emptyToNull((String)this._args.getOption("root")));
                this._loginBrokerHandler.afterSetup();
                this._loginBrokerHandler.start();
                this._loginBrokerHandler.afterStart();
                this.addCommandListener(this._loginBrokerHandler);
                if (this._maxLogin < 0) {
                    this._maxLogin = 100000;
                }
            } else {
                this._loginBrokerHandler = null;
            }
            this._listenThread = new ListenThread(listenPort);
            this._nucleus.newThread(this._listenThread, this.getCellName() + "-listen").start();
            this._nucleus.newThread(new LocationThread(), this.getCellName() + "-location").start();
            this._nucleus.newThread(this._keepAlive, this.getCellName() + "-keepalive").start();
        }
        catch (IllegalArgumentException e) {
            this.start();
            this.kill();
            throw e;
        }
        catch (RuntimeException e) {
            LOGGER.warn("LoginManger >" + this.getCellName() + "< got exception : " + e, (Throwable)e);
            this.start();
            this.kill();
            throw e;
        }
        catch (Exception e) {
            this.start();
            this.kill();
            throw e;
        }
        this.start();
    }

    private static Class<?> toAuthClass(String authClassName, String protocol) throws ClassNotFoundException {
        Class<Object> authClass = null;
        if (authClassName == null) {
            switch (protocol) {
                case "ssh": {
                    authClass = SshSAuth_A.class;
                    break;
                }
                case "raw": {
                    authClass = null;
                    break;
                }
                case "telnet": {
                    authClass = TelnetSAuth_A.class;
                }
            }
        } else if (!authClassName.equals("none")) {
            authClass = Class.forName(authClassName);
        }
        if (authClass != null) {
            LOGGER.info("Using authentication Module: {}", authClass);
        }
        return authClass;
    }

    private static String checkProtocol(String protocol) throws IllegalArgumentException {
        if (protocol == null) {
            protocol = "telnet";
        }
        if (!(protocol.equals("ssh") || protocol.equals("telnet") || protocol.equals("raw"))) {
            throw new IllegalArgumentException("Protocol must be telnet or ssh or raw");
        }
        return protocol;
    }

    @Override
    public CellVersion getCellVersion() {
        return this._version;
    }

    public Object ac_get_children(Args args) {
        boolean binary = args.hasOption("binary");
        if (binary) {
            String[] list = this._children.keySet().toArray(new String[this._children.size()]);
            return new LoginManagerChildrenInfo(this.getCellName(), this.getCellDomainName(), list);
        }
        StringBuilder sb = new StringBuilder();
        for (String child : this._children.keySet()) {
            sb.append(child).append("\n");
        }
        return sb.toString();
    }

    public String ac_set_keepalive_$_1(Args args) {
        long keepAlive = Long.parseLong(args.argv(0));
        this._keepAlive.setKeepAlive(keepAlive * 1000L);
        return "keepAlive value set to " + keepAlive + " seconds";
    }

    public void runKeepAlive() {
        for (Object o : this._children.values()) {
            if (!(o instanceof KeepAliveListener)) continue;
            try {
                ((KeepAliveListener)o).keepAlive();
            }
            catch (Throwable t) {
                LOGGER.warn("Problem reported by : {} : {}", o, (Object)t);
            }
        }
    }

    @Override
    public String toString() {
        return "p=" + (this._listenThread == null ? "???" : "" + this._listenThread.getListenPort()) + ";c=" + this._loginCellFactory.getName();
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("  -- Login Manager $Revision: 1.46 $");
        pw.println("  Listen Port    : " + this._listenThread.getListenPort());
        pw.println("  Protocol engine: " + this._loginCellFactory.getName());
        pw.println("  Protocol       : " + this._protocol);
        pw.println("  NioChannel     : " + (this._listenThread._serverSocket.getChannel() != null));
        pw.println("  Auth Class     : " + this._authClass);
        pw.println("  Logins created : " + this._loginCounter);
        pw.println("  Logins failed  : " + this._loginFailures);
        pw.println("  Logins denied  : " + this._connectionDeniedCounter);
        pw.println("  KeepAlive      : " + this._keepAlive.getKeepAlive() / 1000L);
        if (this._maxLogin > -1) {
            pw.println("  Logins/max     : " + this._children.size() + "/" + this._maxLogin);
        }
        if (this._locationManager != null) {
            pw.println("  Location Mgr   : " + this._locationManager + " (" + (this._sending ? "Sending" : "Informed") + ")");
        }
        if (this._loginBrokerHandler != null) {
            pw.println("  LoginBroker Info :");
            this._loginBrokerHandler.getInfo(pw);
        }
    }

    public String ac_set_max_logins_$_1(Args args) {
        int n = Integer.parseInt(args.argv(0));
        Preconditions.checkArgument((n == -1 || this._maxLogin >= 0 ? 1 : 0) != 0, (Object)"Can't switch off maxLogin feature");
        Preconditions.checkArgument((n >= 0 || this._maxLogin == -1 ? 1 : 0) != 0, (Object)"Can't switch on maxLogin feature");
        this._maxLogin = n;
        this.loadChanged();
        return "";
    }

    @Override
    public void cleanUp() {
        LOGGER.info("cleanUp requested by nucleus, closing listen socket");
        if (this._listenThread != null) {
            this._listenThread.shutdown();
        }
        if (this._loginBrokerHandler != null) {
            this._loginBrokerHandler.beforeStop();
            this._loginBrokerHandler.stop();
        }
        if (this._scheduledExecutor != null) {
            this._scheduledExecutor.shutdown();
        }
        LOGGER.info("Bye Bye");
    }

    private void loadChanged() {
        int children = this._children.size();
        LOGGER.info("New child count : {}", (Object)children);
        if (this._loginBrokerHandler != null) {
            this._loginBrokerHandler.setLoad(children, this._maxLogin);
        }
    }

    @Override
    public boolean validateUser(String userName, String password) {
        String[] request = new String[]{"request", userName, "check-password", userName, password};
        try {
            CellMessage msg = new CellMessage(this._authenticator, (Serializable)request);
            msg = this.getNucleus().sendAndWait(msg, 10000L);
            if (msg == null) {
                LOGGER.warn("Pam request timed out {}", (Object[])Thread.currentThread().getStackTrace());
                return false;
            }
            Object[] r = (Object[])msg.getMessageObject();
            return (Boolean)r[5];
        }
        catch (NoRouteToCellException e) {
            LOGGER.warn(e.getMessage());
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException e) {
            LOGGER.warn(e.getCause().getMessage());
            return false;
        }
    }

    private class RunEngineThread
    implements Runnable {
        private Socket _socket;

        private RunEngineThread(Socket socket) {
            this._socket = socket;
        }

        @Override
        public void run() {
            Thread t = Thread.currentThread();
            try {
                LOGGER.info("acceptThread ({}): creating protocol engine", (Object)t);
                StreamEngine engine = LoginManager.this._authConstructor != null ? StreamEngineFactory.newStreamEngine(this._socket, LoginManager.this._protocol, LoginManager.this._nucleus, LoginManager.this.getArgs()) : StreamEngineFactory.newStreamEngineWithoutAuth(this._socket, LoginManager.this._protocol);
                String userName = Subjects.getDisplayName((Subject)engine.getSubject());
                LOGGER.info("acceptThread ({}): connection created for user {}", (Object)t, (Object)userName);
                int p = userName.indexOf(64);
                if (p > -1) {
                    userName = p == 0 ? "unknown" : userName.substring(0, p);
                }
                Cell cell = LoginManager.this._loginCellFactory.newCell(engine, userName);
                if (LoginManager.this._maxLogin > -1) {
                    try {
                        Method m = cell.getClass().getMethod("getCellName", new Class[0]);
                        String cellName = (String)m.invoke((Object)cell, new Object[0]);
                        LOGGER.info("Invoked cell name : {}", (Object)cellName);
                        if (LoginManager.this._children.putIfAbsent(cellName, cell) == DEAD_CELL) {
                            LoginManager.this._children.remove(cellName, DEAD_CELL);
                        }
                        LoginManager.this.loadChanged();
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ee) {
                        LOGGER.warn("Can't determine child name", (Throwable)ee);
                    }
                }
                LoginManager.this._loginCounter.incrementAndGet();
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                LOGGER.warn("Exception (ITE) in secure protocol : {}", cause);
                try {
                    this._socket.close();
                }
                catch (IOException ee) {
                    // empty catch block
                }
                LoginManager.this._loginFailures.incrementAndGet();
            }
            catch (Exception e) {
                LOGGER.warn("Exception in secure protocol : {}", (Object)e.toString());
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                LoginManager.this._loginFailures.incrementAndGet();
            }
        }
    }

    public static class ShutdownEngine
    implements Runnable {
        private final Socket _socket;

        public ShutdownEngine(Socket socket) {
            this._socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                InputStream inputStream = this._socket.getInputStream();
                OutputStream outputStream = this._socket.getOutputStream();
                outputStream.close();
                byte[] buffer = new byte[1024];
                while (inputStream.read(buffer, 0, buffer.length) > 0) {
                }
                inputStream.close();
            }
            catch (IOException ee) {
                LOGGER.warn("Shutdown : {}", (Object)ee.getMessage());
            }
            finally {
                try {
                    LOGGER.debug("Socket CLOSE (ACCEPT) remote = {} local = {}", (Object)this._socket.getRemoteSocketAddress(), (Object)this._socket.getLocalSocketAddress());
                    this._socket.close();
                }
                catch (IOException iOException) {}
            }
            LOGGER.info("Shutdown : done");
        }
    }

    private class ListenThread
    implements Runnable {
        private static final int SHUTDOWN_TIMEOUT = 60000;
        private final InetSocketAddress _socketAddress;
        private final Constructor<?> _ssfConstructor;
        private final String[] _farctoryArgs;
        private final long _acceptErrorTimeout;
        private final boolean _isDedicated;
        private volatile boolean _shutdown;
        private ServerSocket _serverSocket;

        private ListenThread(int listenPort) throws Exception {
            long timeout;
            try {
                timeout = Long.parseLong(LoginManager.this._args.getOpt("acceptErrorWait"));
            }
            catch (NumberFormatException e) {
                timeout = 0L;
            }
            this._acceptErrorTimeout = timeout;
            String listen = LoginManager.this._args.getOpt("listen");
            if (listen == null || listen.equals("any")) {
                this._socketAddress = new InetSocketAddress(listenPort);
                this._isDedicated = false;
            } else {
                this._socketAddress = new InetSocketAddress(InetAddress.getByName(listen), listenPort);
                this._isDedicated = true;
            }
            String ssf = LoginManager.this._args.getOpt("socketfactory");
            if (ssf != null) {
                Constructor<?> constructor;
                StringTokenizer st = new StringTokenizer(ssf, ",");
                Preconditions.checkArgument((st.countTokens() >= 2 ? 1 : 0) != 0, (Object)"Invalid Arguments for 'socketfactory'");
                String tunnelFactoryClass = st.nextToken();
                this._farctoryArgs = new String[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    this._farctoryArgs[i] = st.nextToken();
                    ++i;
                }
                Class<?> ssfClass = Class.forName(tunnelFactoryClass);
                try {
                    constructor = ssfClass.getConstructor(String[].class, Map.class);
                }
                catch (Exception ee) {
                    constructor = ssfClass.getConstructor(String[].class);
                }
                this._ssfConstructor = constructor;
            } else {
                this._ssfConstructor = null;
                this._farctoryArgs = null;
            }
            this.openPort();
        }

        private void openPort() throws Exception {
            if (this._ssfConstructor == null) {
                this._serverSocket = ServerSocketChannel.open().socket();
            } else {
                Object obj;
                try {
                    if (this._ssfConstructor.getParameterTypes().length == 2) {
                        HashMap map = Maps.newHashMap(LoginManager.this.getDomainContext());
                        map.put("UserValidatable", LoginManager.this);
                        obj = this._ssfConstructor.newInstance(this._farctoryArgs, map);
                    } else {
                        obj = this._ssfConstructor.newInstance(new Object[]{this._farctoryArgs});
                    }
                }
                catch (InvocationTargetException e) {
                    Throwables.propagateIfPossible((Throwable)e.getCause(), Exception.class);
                    throw new RuntimeException(e);
                }
                Method meth = obj.getClass().getMethod("createServerSocket", new Class[0]);
                this._serverSocket = (ServerSocket)meth.invoke(obj, new Object[0]);
                LOGGER.info("ListenThread : got serverSocket class : {}", (Object)this._serverSocket.getClass().getName());
            }
            this._serverSocket.bind(this._socketAddress);
            if (LoginManager.this._loginBrokerHandler != null) {
                LoginManager.this._loginBrokerHandler.setPort(this.getListenPort());
                LoginManager.this._loginBrokerHandler.setAddresses(this.getInetAddresses());
            }
            LOGGER.info("Listening on {}", (Object)this._serverSocket.getLocalSocketAddress());
            LOGGER.trace("Nio Socket Channel : {}", (Object)(this._serverSocket.getChannel() != null ? 1 : 0));
        }

        public int getListenPort() {
            return this._serverSocket.getLocalPort();
        }

        public List<InetAddress> getInetAddresses() {
            if (!this._isDedicated) {
                ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
                try {
                    Enumeration<NetworkInterface> ifList = NetworkInterface.getNetworkInterfaces();
                    while (ifList.hasMoreElements()) {
                        NetworkInterface ne = ifList.nextElement();
                        Enumeration<InetAddress> ipList = ne.getInetAddresses();
                        while (ipList.hasMoreElements()) {
                            InetAddress ia = ipList.nextElement();
                            if (!(ia instanceof Inet4Address) || ia.isLoopbackAddress()) continue;
                            addresses.add(ia);
                        }
                    }
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                return addresses;
            }
            if (this._serverSocket != null) {
                return Collections.singletonList(this._serverSocket.getInetAddress());
            }
            return Collections.emptyList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            ExecutorService executor = Executors.newCachedThreadPool(LoginManager.this._nucleus);
            try {
                LoginManager.this._loginCellFactory.startAsync().awaitRunning();
                while (!this._serverSocket.isClosed()) {
                    try {
                        Socket socket = this._serverSocket.accept();
                        socket.setKeepAlive(true);
                        socket.setTcpNoDelay(true);
                        LOGGER.debug("Socket OPEN (ACCEPT) remote = {} local = {}", (Object)socket.getRemoteSocketAddress(), (Object)socket.getLocalSocketAddress());
                        LOGGER.info("Nio Channel (accept) : {}", (Object)(socket.getChannel() != null ? 1 : 0));
                        int currentChildCount = LoginManager.this._children.size();
                        LOGGER.info("New connection : {}", (Object)currentChildCount);
                        if (LoginManager.this._maxLogin > -1 && currentChildCount >= LoginManager.this._maxLogin) {
                            LoginManager.this._connectionDeniedCounter.incrementAndGet();
                            LOGGER.warn("Connection denied: Number of allowed logins exceeded ({} > {}).", (Object)currentChildCount, (Object)LoginManager.this._maxLogin);
                            executor.execute(new ShutdownEngine(socket));
                            continue;
                        }
                        LOGGER.info("Connection request from {}", (Object)socket.getInetAddress());
                        executor.execute(new RunEngineThread(socket));
                    }
                    catch (InterruptedIOException ioe) {
                        LOGGER.debug("Listen thread interrupted");
                        try {
                            this._serverSocket.close();
                        }
                        catch (IOException ignored) {}
                    }
                    catch (IOException ioe) {
                        if (this._serverSocket.isClosed()) continue;
                        LOGGER.error("I/O error: {}", (Object)ioe.toString());
                        try {
                            this._serverSocket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (this._acceptErrorTimeout <= 0L) continue;
                        ListenThread listenThread = this;
                        // MONITORENTER : listenThread
                        while (!this._shutdown && this._serverSocket.isClosed()) {
                            LOGGER.warn("Sleeping {} ms before reopening server socket", (Object)this._acceptErrorTimeout);
                            this.wait(this._acceptErrorTimeout);
                            if (this._shutdown) continue;
                            try {
                                this.openPort();
                                LOGGER.warn("Resuming operation");
                            }
                            catch (Exception ee) {
                                LOGGER.warn("Failed to open socket: {}", (Object)ee.toString());
                            }
                        }
                        // MONITOREXIT : listenThread
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            finally {
                this.terminateChildren();
                this.shutdownAndAwaitTermination(executor);
                this.terminateChildren();
                this.awaitTerminationOfChildren();
                LoginManager.this._loginCellFactory.stopAsync();
                LOGGER.trace("Listen thread finished");
            }
        }

        private void shutdownAndAwaitTermination(ExecutorService executor) {
            executor.shutdown();
            try {
                executor.awaitTermination(60000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private void awaitTerminationOfChildren() {
            try {
                for (Object child : LoginManager.this._children.values()) {
                    if (!(child instanceof CellAdapter)) continue;
                    LoginManager.this.getNucleus().join(((CellAdapter)child).getCellName());
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }

        private void terminateChildren() {
            for (Object child : LoginManager.this._children.values()) {
                if (!(child instanceof CellAdapter)) continue;
                LoginManager.this.getNucleus().kill(((CellAdapter)child).getCellName());
            }
        }

        public synchronized void shutdown() {
            LOGGER.info("Listen thread shutdown requested");
            if (this._shutdown || this._serverSocket == null) {
                return;
            }
            this._shutdown = true;
            try {
                LOGGER.debug("Socket SHUTDOWN local = {}", (Object)this._serverSocket.getLocalSocketAddress());
                this._serverSocket.close();
            }
            catch (IOException ee) {
                LOGGER.warn("ServerSocket close: {}", (Object)ee.toString());
            }
            this.notifyAll();
            LOGGER.info("Shutdown sequence done");
        }
    }

    private class KeepAliveThread
    implements Runnable {
        private long _keepAlive;

        private KeepAliveThread(long keepAlive) {
            this._keepAlive = keepAlive;
        }

        @Override
        public synchronized void run() {
            LOGGER.info("KeepAlive Thread started");
            while (!Thread.interrupted()) {
                try {
                    if (this._keepAlive < 1L) {
                        this.wait();
                    } else {
                        this.wait(this._keepAlive);
                    }
                }
                catch (InterruptedException ie) {
                    LOGGER.info("KeepAlive thread done (interrupted)");
                    break;
                }
                if (this._keepAlive <= 0L) continue;
                try {
                    LoginManager.this.runKeepAlive();
                }
                catch (Throwable t) {
                    LOGGER.warn("runKeepAlive reported : {}", (Object)t.toString());
                }
            }
        }

        private synchronized void setKeepAlive(long keepAlive) {
            this._keepAlive = keepAlive;
            LOGGER.info("Keep Alive value changed to {}", (Object)this._keepAlive);
            this.notifyAll();
        }

        private long getKeepAlive() {
            return this._keepAlive;
        }
    }

    private class LocationThread
    implements Runnable {
        private LocationThread() {
        }

        @Override
        public void run() {
            int listenPort = LoginManager.this._listenThread.getListenPort();
            LOGGER.info("Sending 'listeningOn {} {}'", (Object)LoginManager.this.getCellName(), (Object)listenPort);
            LoginManager.this._sending = true;
            String dest = LoginManager.this._locationManager;
            if (dest == null) {
                return;
            }
            CellPath path = new CellPath(dest);
            CellMessage msg = new CellMessage(path, (Serializable)((Object)("listening on " + LoginManager.this.getCellName() + " " + listenPort)));
            int i = 0;
            while (!Thread.interrupted()) {
                LOGGER.info("Sending ({}) 'listening on {} {}'", new Object[]{i, LoginManager.this.getCellName(), listenPort});
                try {
                    if (LoginManager.this.getNucleus().sendAndWait(msg, 5000L) != null) {
                        LOGGER.info("Portnumber successfully sent to {}", (Object)dest);
                        LoginManager.this._sending = false;
                        break;
                    }
                    LOGGER.warn("No reply from {}", (Object)dest);
                }
                catch (InterruptedException ie) {
                    LOGGER.warn("'send portnumber thread' interrupted");
                    break;
                }
                catch (Exception ee) {
                    LOGGER.warn("Problem sending portnumber {}", (Object)ee.toString());
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    LOGGER.warn("'send portnumber thread' (sleep) interrupted");
                    break;
                }
                ++i;
            }
        }
    }

    private class LoginEventListener
    implements CellEventListener {
        private LoginEventListener() {
        }

        @Override
        public void cellCreated(CellEvent ce) {
        }

        @Override
        public void cellDied(CellEvent ce) {
            String removedCell = ce.getSource().toString();
            if (!removedCell.startsWith(LoginManager.this.getCellName())) {
                return;
            }
            Object cell = LoginManager.this._children.putIfAbsent(removedCell, DEAD_CELL);
            if (cell != null) {
                LoginManager.this._children.remove(removedCell, cell);
            }
            LOGGER.info("LoginEventListener : removing : {}", (Object)removedCell);
            LoginManager.this.loadChanged();
        }

        @Override
        public void cellExported(CellEvent ce) {
        }

        @Override
        public void routeAdded(CellEvent ce) {
        }

        @Override
        public void routeDeleted(CellEvent ce) {
        }
    }
}

