/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.multicaster;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.UOID;
import dmg.cells.services.multicaster.MulticastClose;
import dmg.cells.services.multicaster.MulticastEvent;
import dmg.cells.services.multicaster.MulticastMessage;
import dmg.cells.services.multicaster.MulticastOpen;
import dmg.cells.services.multicaster.MulticastRegister;
import dmg.cells.services.multicaster.MulticastUnregister;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.dcache.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastCell
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(MulticastCell.class);
    private CellNucleus _nucleus;
    private Args _args;
    private final Hashtable<String, Hashtable<Object, Entry>> _classHash = new Hashtable();
    private final Object _ioLock = new Object();

    public MulticastCell(String name, String args) {
        super(name, args, false);
        this._nucleus = this.getNucleus();
        this._args = this.getArgs();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void messageArrived(CellMessage message) {
        block14: {
            Serializable obj = message.getMessageObject();
            CellPath path = (CellPath)message.getSourcePath().clone();
            if (obj instanceof NoRouteToCellException) {
                Object object = this._ioLock;
                synchronized (object) {
                    NoRouteToCellException nrtc = (NoRouteToCellException)obj;
                    _log.info("NRTCE arrived : " + nrtc);
                    this.removeByUOID(nrtc.getUOID());
                    return;
                }
            }
            if (!(obj instanceof MulticastEvent)) {
                return;
            }
            MulticastEvent mce = (MulticastEvent)obj;
            try {
                if (mce instanceof MulticastOpen) {
                    MulticastOpen mco = (MulticastOpen)mce;
                    this.openArrived(mco, path);
                    mce.isOk(true);
                    break block14;
                }
                if (mce instanceof MulticastClose) {
                    MulticastClose mcc = (MulticastClose)mce;
                    this.closeArrived(mcc);
                    mce.isOk(true);
                    return;
                }
                if (mce instanceof MulticastRegister) {
                    MulticastRegister mcr = (MulticastRegister)mce;
                    this.registerArrived(mcr, path);
                    mce.isOk(true);
                    break block14;
                }
                if (mce instanceof MulticastUnregister) {
                    MulticastUnregister mcu = (MulticastUnregister)mce;
                    this.unregisterArrived(mcu, path);
                    mce.isOk(true);
                    return;
                }
                if (mce instanceof MulticastMessage) {
                    MulticastMessage mcm = (MulticastMessage)mce;
                    this.registerMessageArrived(mcm, path, message);
                    return;
                }
                throw new IllegalArgumentException("Illegal Command : " + mce);
            }
            catch (Exception ee) {
                _log.warn(ee.toString(), (Throwable)ee);
                mce.isOk(false);
                mce.setReplyObject(ee);
            }
        }
        message.revertDirection();
        try {
            this.sendMessage(message);
        }
        catch (Exception e) {
            _log.warn("Failed to reply : " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getEntry(String eventClass, String eventName) {
        Hashtable<String, Hashtable<Object, Entry>> hashtable = this._classHash;
        synchronized (hashtable) {
            Hashtable<Object, Entry> names = this._classHash.get(eventClass);
            if (names == null) {
                return null;
            }
            return names.get(eventName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntry(String eventClass, String eventName) throws NoSuchElementException {
        Hashtable<String, Hashtable<Object, Entry>> hashtable = this._classHash;
        synchronized (hashtable) {
            Hashtable<Object, Entry> names = this._classHash.get(eventClass);
            if (names == null) {
                throw new NoSuchElementException("Class not found : " + eventClass);
            }
            Entry obj = names.get(eventName);
            if (obj == null) {
                throw new NoSuchElementException("Not found : " + eventClass + ":" + eventName);
            }
            names.remove(eventName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry newEntry(String eventClass, String eventName, boolean overwrite) {
        Hashtable<String, Hashtable<Object, Entry>> hashtable = this._classHash;
        synchronized (hashtable) {
            Entry entry = this.getEntry(eventClass, eventName);
            if (entry != null && !overwrite) {
                throw new IllegalArgumentException("Duplicate entry");
            }
            entry = new Entry(eventClass, eventName);
            Hashtable<Object, Entry> hash = this._classHash.get(eventClass);
            if (hash == null) {
                hash = new Hashtable();
                this._classHash.put(eventClass, hash);
            }
            hash.put(eventName, entry);
            return entry;
        }
    }

    private void registerArrived(MulticastRegister register, CellPath path) {
        String eventName;
        String eventClass = register.getEventClass();
        Entry entry = this.getEntry(eventClass, eventName = register.getEventName());
        if (entry == null) {
            throw new NoSuchElementException("Not found : " + eventClass + ":" + eventName);
        }
        entry.addClient(new Client(path.revert()));
        register.setServerInfo(entry.getServerDetail(), entry.getServerState());
    }

    private void unregisterArrived(MulticastUnregister register, CellPath path) {
        String eventName;
        String eventClass = register.getEventClass();
        Entry entry = this.getEntry(eventClass, eventName = register.getEventName());
        if (entry == null) {
            return;
        }
        entry.removeClient(path.revert());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMessageArrived(MulticastMessage message, CellPath path, CellMessage originalMessage) {
        String eventClass = message.getEventClass();
        String eventName = message.getEventName();
        Serializable info = message.getMessage();
        Entry entry = this.getEntry(eventClass, eventName);
        if (entry == null) {
            throw new NoSuchElementException("Not found : " + eventClass + ":" + eventName);
        }
        entry.setServerState(info);
        CellPath serverPath = entry.getSourcePath();
        _log.info("message Path : " + path + "; serverPath : " + serverPath);
        if (path.equals(serverPath)) {
            for (Client client : entry.clients()) {
                CellPath outPath = client.getPath();
                try {
                    _log.info("Distributing to " + outPath);
                    Object object = this._ioLock;
                    synchronized (object) {
                        CellMessage msg = new CellMessage(outPath, message);
                        this.sendMessage(msg);
                        client.setUOID(msg.getUOID());
                    }
                }
                catch (NoRouteToCellException nrtce) {
                    _log.warn("remove enforced for client " + path);
                    entry.removeClient(path);
                }
                catch (Throwable t) {
                    _log.warn(t.toString(), t);
                }
            }
        } else {
            _log.info("Message from client " + path);
            serverPath = serverPath.revert();
            originalMessage.getDestinationPath().add(serverPath);
            originalMessage.nextDestination();
            try {
                this.sendMessage(originalMessage);
            }
            catch (Exception ee) {
                _log.warn(ee.toString(), (Throwable)ee);
            }
        }
    }

    private void openArrived(MulticastOpen open, CellPath path) {
        Entry entry = this.newEntry(open.getEventClass(), open.getEventName(), open.isOverwrite());
        entry.setSourcePath(path);
        entry.setServerDetail(open.getServerDetail());
        entry.setServerState(open.getServerState());
    }

    private void closeArrived(MulticastClose close) {
        Entry entry = this.getEntry(close.getEventClass(), close.getEventName());
        if (entry == null) {
            return;
        }
        this.removeEntry(close.getEventClass(), close.getEventName());
        for (Client client : entry.clients()) {
            CellPath path = client.getPath();
            try {
                _log.info("Close Distributing to " + path);
                this.sendMessage(new CellMessage(path, close));
            }
            catch (Throwable t) {
                _log.warn(t.toString(), t);
            }
        }
    }

    private void removeByUOID(UOID uoid) {
        for (Map map : this._classHash.values()) {
            for (Entry entry : map.values()) {
                for (Client client : entry.clients()) {
                    UOID u = client.getUOID();
                    if (u == null || !u.equals(uoid)) continue;
                    entry.removeClient(client.getPath());
                    _log.info("Removed : " + client);
                    return;
                }
            }
        }
    }

    @Override
    public void getInfo(PrintWriter pw) {
        for (Map map : this._classHash.values()) {
            for (Entry entry : map.values()) {
                pw.println(entry.toString());
            }
        }
    }

    private class Entry {
        private String _eventClass;
        private String _eventName;
        private Serializable _serverDetail;
        private Serializable _serverState;
        private CellPath _path;
        private Hashtable<CellPath, Client> _clients = new Hashtable();

        private Entry(String eventClass, String eventName) {
            this._eventClass = eventClass;
            this._eventName = eventName;
        }

        private void addClient(Client client) {
            this._clients.put(client.getPath(), client);
        }

        private void removeClient(CellPath path) {
            this._clients.remove(path);
        }

        private Client getClient(CellPath path) {
            return this._clients.get(path);
        }

        private Collection<Client> clients() {
            return new ArrayList<Client>(this._clients.values());
        }

        private void setSourcePath(CellPath path) {
            this._path = path;
        }

        private CellPath getSourcePath() {
            return this._path;
        }

        private void setServerState(Serializable serverState) {
            this._serverState = serverState;
        }

        private Serializable getServerState() {
            return this._serverState;
        }

        private void setServerDetail(Serializable serverDetail) {
            this._serverDetail = serverDetail;
        }

        private Serializable getServerDetail() {
            return this._serverDetail;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" Server   : ").append(this._eventClass).append(":").append(this._eventName).append("\n");
            sb.append("   Detail : ").append(this._serverDetail == null ? "<none>" : this._serverDetail.toString()).append("\n");
            sb.append("   State  : ").append(this._serverState == null ? "<none>" : this._serverState.toString()).append("\n");
            sb.append("   Path   : ").append(this._path == null ? "<none>" : this._path.toString()).append("\n");
            for (CellPath key : this._clients.keySet()) {
                Client value = this._clients.get(key);
                sb.append("      ").append(key.toString()).append("=").append(value.toString()).append("\n");
            }
            return sb.toString();
        }
    }

    private class Client {
        private UOID _uoid;
        private CellPath _path;

        private Client(CellPath path) {
            this._path = path;
        }

        private CellPath getPath() {
            return this._path;
        }

        private UOID getUOID() {
            return this._uoid;
        }

        private void setUOID(UOID uoid) {
            this._uoid = uoid;
        }

        public String toString() {
            return "Client" + this._path;
        }
    }
}

