/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.kerberos;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class Base64 {
    private static String __base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static String __rest = "!@#$%^&*()_+=-][]{};'\\\":|<>?,./ `~";

    public static String encode(byte[] data) {
        if (data == null) {
            throw new NullPointerException("data == null ");
        }
        StringBuilder out = new StringBuilder();
        int c = 0;
        for (int i = 0; i < data.length; ++i) {
            int d = data[i];
            d = d < 0 ? d + 256 : d;
            c <<= 8;
            c += d;
            if (i % 3 != 2) continue;
            out.append(__base64.charAt((c & 0xFC0000) >> 18));
            out.append(__base64.charAt((c & 0x3F000) >> 12));
            out.append(__base64.charAt((c & 0xFC0) >> 6));
            out.append(__base64.charAt((c & 0x3F) >> 0));
            c = 0;
        }
        int r = data.length % 3;
        if (r == 1) {
            out.append(__base64.charAt(((c <<= 16) & 0xFC0000) >> 18));
            out.append(__base64.charAt((c & 0x3F000) >> 12));
            out.append('=');
            out.append('=');
        } else if (r == 2) {
            out.append(__base64.charAt(((c <<= 8) & 0xFC0000) >> 18));
            out.append(__base64.charAt((c & 0x3F000) >> 12));
            out.append(__base64.charAt((c & 0xFC0) >> 6));
            out.append('=');
        }
        return out.toString();
    }

    public static byte[] decode(String str) {
        int x;
        int n = str.length();
        if (n == 0) {
            return new byte[0];
        }
        if (n % 4 != 0) {
            throw new IllegalArgumentException("Not a base64(not mod 4)");
        }
        int rn = n;
        if (str.charAt(rn - 1) == '=') {
            --rn;
        }
        if (str.charAt(rn - 1) == '=') {
            --rn;
        }
        int diff = n - rn;
        byte[] data = new byte[n / 4 * 3 - diff];
        int d = 0;
        int dataPos = 0;
        for (int i = 0; i < rn; ++i) {
            char c = str.charAt(i);
            int p = __base64.indexOf(c);
            if (p < 0) {
                throw new IllegalArgumentException("Not a base64 (wrong char set)");
            }
            d <<= 6;
            d += p;
            if (i % 4 != 3) continue;
            x = d >> 16 & 0xFF;
            data[dataPos++] = (byte)(x > 128 ? x - 256 : x);
            x = d >> 8 & 0xFF;
            data[dataPos++] = (byte)(x > 128 ? x - 256 : x);
            x = d & 0xFF;
            data[dataPos++] = (byte)(x > 128 ? x - 256 : x);
        }
        if (diff == 2) {
            x = (d <<= 12) >> 16 & 0xFF;
            data[dataPos++] = (byte)(x > 128 ? x - 256 : x);
        } else if (diff == 1) {
            x = (d <<= 6) >> 16 & 0xFF;
            data[dataPos++] = (byte)(x > 128 ? x - 256 : x);
            x = d >> 8 & 0xFF;
            data[dataPos++] = (byte)(x > 128 ? x - 256 : x);
        }
        return data;
    }

    private static void displayHexLine(byte[] data, int off, int size, PrintWriter pw) {
        int col;
        size = Math.min(size, 16);
        int pos = off;
        for (col = 0; col < size; ++col) {
            pw.print(Base64.byteToHex(data[pos + col]));
            pw.print(" ");
            if (col != 7) continue;
            pw.print(" ");
        }
        while (col < 16) {
            pw.print("-- ");
            if (col == 7) {
                pw.print(" ");
            }
            ++col;
        }
        pw.print(" *");
        for (col = 0; col < size; ++col) {
            char c = (char)data[pos + col];
            if (Character.isLetterOrDigit(c) || __rest.indexOf(c) > -1) {
                pw.print(c);
                continue;
            }
            pw.print(".");
        }
        while (col < 16) {
            pw.print(" ");
            ++col;
        }
        pw.println("*");
    }

    public static void displayHex(byte[] data) {
        Base64.displayHex(data, new PrintWriter(new OutputStreamWriter(System.out)));
    }

    public static void displayHex(byte[] data, PrintWriter pw) {
        int l = data.length;
        int pos = 0;
        int rest = data.length;
        int row = 0;
        while (true) {
            Base64.displayHexLine(data, pos, Math.min(rest, 16), pw);
            if ((rest -= 16) <= 0) break;
            ++row;
            pos += 16;
        }
        pw.flush();
    }

    public static String byteToHex(int d) {
        d = (d &= 0xFF) < 0 ? d + 256 : d;
        String x = "" + Integer.toHexString(d);
        return x.length() == 1 ? "0" + x : x;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Usage : ... <file> ...");
            System.exit(4);
        }
        File file = new File(args[0]);
        long len = file.length();
        byte[] data = new byte[(int)len];
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        in.readFully(data);
        in.close();
        Base64.displayHex(data);
        System.exit(0);
    }
}

