/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.snmp;

import dmg.protocols.snmp.SnmpObject;
import dmg.protocols.snmp.SnmpObjectHeader;

public class SnmpOctetString
extends SnmpObject {
    String _string = "";

    SnmpOctetString(SnmpObjectHeader head, byte[] b, int offIn, int maxLen) {
        int off = offIn + head.getCodedLength();
        int len = head.getLength();
        boolean printable = true;
        for (int i = off; i < off + len; ++i) {
            if (b[i] >= 16 || b[i] == 10 || b[i] == 13) continue;
            printable = false;
            break;
        }
        if (printable) {
            this._string = new String(b, off, len);
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = off; i < off + len; ++i) {
                int x = b[i];
                x = x == 10 || x == 13 ? 32 : x;
                sb.append(Integer.toHexString(x < 0 ? x + 256 : x)).append(":");
            }
            this._string = sb.toString();
        }
        this.setCodedLength(head.getCodedLength() + len);
    }

    public SnmpOctetString(String str) {
        this._string = str;
    }

    public String toString() {
        return this._string;
    }

    public String stringValue() {
        return this._string;
    }

    @Override
    public byte[] getSnmpBytes() {
        byte[] b = this._string.getBytes();
        SnmpObjectHeader head = new SnmpObjectHeader(4, b.length);
        int headLen = head.getCodedLength();
        byte[] out = new byte[headLen + b.length];
        System.arraycopy(head.getSnmpBytes(), 0, out, 0, headLen);
        System.arraycopy(b, 0, out, headLen, b.length);
        return out;
    }
}

