/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ssh;

import dmg.protocols.ssh.SshRsaKey;

public class SshAuthMethod {
    private int _methodType;
    private String _user;
    private SshRsaKey _key;
    public static final int AUTH_RHOSTS = 1;
    public static final int AUTH_RSA = 2;
    public static final int AUTH_PASSWORD = 3;
    public static final int AUTH_RHOSTS_RSA = 4;

    public SshAuthMethod(int methodType, String user) {
        this._user = user;
        this._methodType = methodType;
    }

    public SshAuthMethod(int methodType, SshRsaKey key) {
        this._key = key;
        this._methodType = methodType;
        if (!key.isFullIdentity()) {
            throw new IllegalArgumentException("Key must be full identity");
        }
    }

    public SshAuthMethod(int methodType, String user, SshRsaKey key) {
        this._user = user;
        this._key = key;
        this._methodType = methodType;
        if (!key.isFullIdentity()) {
            throw new IllegalArgumentException("Key must be full identity");
        }
    }

    public SshRsaKey getKey() {
        return this._key;
    }

    public String getUser() {
        return this._user;
    }
}

