/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ssh;

import dmg.protocols.ssh.SshPacket;
import dmg.protocols.ssh.SshRsaKey;
import dmg.security.cipher.StreamCipher;

public class SshCmsgAuthRhostsRsa
extends SshPacket {
    SshRsaKey _key;
    String _userName;

    public SshCmsgAuthRhostsRsa(String user, SshRsaKey key) {
        this._key = key;
        this._userName = user;
    }

    public SshCmsgAuthRhostsRsa(SshPacket packet) {
        byte[] payload = packet.getPayload();
        int pos = 0;
        int strBytes = (payload[pos++] & 0xFF) << 24 | (payload[pos++] & 0xFF) << 16 | (payload[pos++] & 0xFF) << 8 | payload[pos++] & 0xFF;
        this._userName = new String(payload, pos, strBytes);
        pos += strBytes;
        int mpBits = (payload[pos++] & 0xFF) << 24 | (payload[pos++] & 0xFF) << 16 | (payload[pos++] & 0xFF) << 8 | payload[pos++] & 0xFF;
        int exLength = (payload[pos++] & 0xFF) << 8 | payload[pos++] & 0xFF;
        byte[] ex = new byte[(exLength + 7) / 8];
        System.arraycopy(payload, pos, ex, 0, ex.length);
        pos += ex.length;
        int mdLength = (payload[pos++] & 0xFF) << 8 | payload[pos++] & 0xFF;
        byte[] md = new byte[(mdLength + 7) / 8];
        System.arraycopy(payload, pos, md, 0, md.length);
        pos += md.length;
        this._key = new SshRsaKey(mpBits, ex, md);
    }

    public SshRsaKey getKey() {
        return this._key;
    }

    public String getUserName() {
        return this._userName;
    }

    @Override
    public byte[] toByteArray(StreamCipher cipher) {
        byte[] userBytes = this._userName.getBytes();
        byte[] keyBytes = this._key.toByteArray();
        byte[] out = new byte[4 + userBytes.length + keyBytes.length];
        int pos = 0;
        this.punchInt(out, pos, userBytes.length);
        System.arraycopy(userBytes, 0, out, pos += 4, userBytes.length);
        System.arraycopy(keyBytes, 0, out, pos += userBytes.length, keyBytes.length);
        pos += keyBytes.length;
        return this.makePacket(cipher, out);
    }
}

