/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ssh;

import dmg.protocols.ssh.SshAuthPassword;
import dmg.protocols.ssh.SshAuthRhostsRsa;
import dmg.protocols.ssh.SshAuthRsa;
import dmg.protocols.ssh.SshAuthenticationException;
import dmg.protocols.ssh.SshClientAuthentication;
import dmg.protocols.ssh.SshClientInputStreamReader;
import dmg.protocols.ssh.SshClientOutputStreamWriter;
import dmg.protocols.ssh.SshCmsgAuthPassword;
import dmg.protocols.ssh.SshCmsgAuthRhostsRsa;
import dmg.protocols.ssh.SshCmsgAuthRsa;
import dmg.protocols.ssh.SshCmsgAuthRsaResponse;
import dmg.protocols.ssh.SshCmsgExecCmd;
import dmg.protocols.ssh.SshCmsgExecShell;
import dmg.protocols.ssh.SshCmsgRequestPty;
import dmg.protocols.ssh.SshCmsgSessionKey;
import dmg.protocols.ssh.SshCmsgUser;
import dmg.protocols.ssh.SshCmsgWindowSize;
import dmg.protocols.ssh.SshCoreEngine;
import dmg.protocols.ssh.SshInputStream;
import dmg.protocols.ssh.SshInputStreamReader;
import dmg.protocols.ssh.SshMsgDebug;
import dmg.protocols.ssh.SshOutputStream;
import dmg.protocols.ssh.SshOutputStreamWriter;
import dmg.protocols.ssh.SshPacket;
import dmg.protocols.ssh.SshProtocolException;
import dmg.protocols.ssh.SshRsaKey;
import dmg.protocols.ssh.SshServerAuthentication;
import dmg.protocols.ssh.SshSmsgAuthRsaChallenge;
import dmg.protocols.ssh.SshSmsgExitStatus;
import dmg.protocols.ssh.SshSmsgFailure;
import dmg.protocols.ssh.SshSmsgPublicKey;
import dmg.protocols.ssh.SshSmsgSuccess;
import dmg.security.digest.Md5;
import dmg.util.StreamEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.security.Principal;
import java.util.Date;
import java.util.Random;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.dcache.auth.UserNamePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshStreamEngine
extends SshCoreEngine
implements StreamEngine {
    private static final Logger _log = LoggerFactory.getLogger(SshStreamEngine.class);
    private final Socket _socket;
    private SshServerAuthentication _serverAuth;
    private SshClientAuthentication _clientAuth;
    private Thread _listenerThread;
    private SshRsaKey _serverIdentity;
    private SshRsaKey _hostIdentity;
    private byte[] _sessionId;
    private final int _mode;
    private boolean _closing;
    private boolean _closed;
    private final Object _closeLock = new Object();
    private InetAddress _remoteAddress;
    private Subject _remoteUser = new Subject();
    private String _terminal;
    private int _width;
    private int _height;
    public static final int SERVER_MODE = 1;
    public static final int CLIENT_MODE = 2;
    private boolean _isActive = true;
    private static final String __version = "SSH-1.5-3333\n";
    private static final int ST_ERROR = -1;
    private static final int ST_INIT = 0;
    private static final int ST_USER = 1;
    private static final int ST_AUTH = 2;
    private static final int ST_PREPARE = 3;
    private static final int ST_INTERACTIVE = 4;
    private static final int ST_SESSION_SEND = 5;
    private static final int ST_USER_SEND = 6;
    private static final int ST_TRY_RSA_AUTH = 7;
    private static final int ST_RSA_RESPONSE = 8;
    private static final int ST_EXEC_SEND = 9;
    private static final int ST_TRY_PASSWORD_AUTH = 10;
    private static final int ST_TRY_RHOSTS_RSA_AUTH = 11;

    public SshStreamEngine(Socket socket, SshServerAuthentication auth) throws IOException, SshAuthenticationException {
        super(socket);
        this._socket = socket;
        this._serverAuth = auth;
        this._mode = 1;
        this._remoteUser.setReadOnly();
        this.runServerProtocol();
    }

    public SshStreamEngine(Socket socket, SshClientAuthentication auth) throws IOException, SshAuthenticationException {
        super(socket);
        this._socket = socket;
        this._clientAuth = auth;
        this._mode = 2;
        this._remoteUser.setReadOnly();
        this.runClientProtocol();
    }

    public int getMode() {
        return this._mode;
    }

    @Override
    public Socket getSocket() {
        return this._socket;
    }

    @Override
    public InputStream getInputStream() {
        return new SshInputStream(this);
    }

    @Override
    public OutputStream getOutputStream() {
        return new SshOutputStream(this);
    }

    public String getName() {
        return Subjects.getUserName((Subject)this._remoteUser);
    }

    @Override
    public Subject getSubject() {
        return this._remoteUser;
    }

    @Override
    public InetAddress getInetAddress() {
        return this._remoteAddress;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this._socket.getLocalAddress();
    }

    @Override
    public String getTerminalType() {
        return this._terminal;
    }

    @Override
    public int getTerminalWidth() {
        return this._width;
    }

    @Override
    public int getTerminalHeight() {
        return this._height;
    }

    @Override
    public Reader getReader() {
        if (this._mode == 1) {
            return new SshInputStreamReader(this.getInputStream(), this.getOutputStream());
        }
        return new SshClientInputStreamReader(this.getInputStream(), this.getOutputStream());
    }

    @Override
    public Writer getWriter() {
        if (this._mode == 1) {
            return new SshOutputStreamWriter(this.getOutputStream());
        }
        return new SshClientOutputStreamWriter(this.getOutputStream());
    }

    private void runClientProtocol() throws IOException, SshAuthenticationException {
        _log.debug("Connected (client)");
        String version = this.readVersionString();
        _log.debug("Received version: {}", (Object)version);
        _log.debug("Sending our version: {}", (Object)__version);
        this.writeString(__version);
        this.client_loop();
        _log.debug("Preparation Loop finished");
    }

    private void runServerProtocol() throws IOException, SshAuthenticationException {
        _log.debug("Connected (server)");
        this._remoteAddress = this._socket.getInetAddress();
        this.writeString(__version);
        String version = this.readVersionString();
        _log.debug("Client has version: {}", (Object)version);
        this._serverIdentity = this._serverAuth.getServerRsaKey();
        this._hostIdentity = this._serverAuth.getHostRsaKey();
        if (this._serverIdentity == null || this._hostIdentity == null) {
            throw new SshAuthenticationException("Either server or host Identity not found");
        }
        SshSmsgPublicKey key = new SshSmsgPublicKey(this._serverIdentity, this._hostIdentity, 70, 28);
        this._sessionId = key.getSessionId();
        this.writePacket(key);
        this.server_loop();
        _log.debug("Preparation Loop finished");
    }

    public void close() throws IOException {
        this.close(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int val) throws IOException {
        _log.debug("close(closing={}; closed={})", (Object)this._closing, (Object)this._closed);
        if (this._mode == 1) {
            Object object = this._closeLock;
            synchronized (object) {
                if (!this._closing && !this._closed) {
                    this._closing = true;
                    this._isActive = false;
                    this.shutdown(val);
                }
            }
        }
        Object object = this._closeLock;
        synchronized (object) {
            if (!this._closed) {
                throw new IOException("Client not allowed to close connection first");
            }
        }
    }

    private void shutdown(int value) throws IOException {
        this.writePacket(new SshSmsgExitStatus(value));
        this._socket.shutdownOutput();
        this.waitForClientConfirmation();
        this.waitForClientClose();
        this.confirmed();
    }

    private void waitForClientConfirmation() throws IOException {
        SshPacket packet = this.readPacket();
        if (packet != null && packet.getType() == 19) {
            packet = this.readPacket();
        }
        if (packet != null && packet.getType() != 33) {
            _log.warn("received unexpected message (type={}) after server send exit message; discarding any subsequent data.", (Object)packet.getType());
            while ((packet = this.readPacket()) != null && packet.getType() != 33) {
            }
        }
    }

    private void waitForClientClose() throws IOException {
        SshPacket packet = this.readPacket();
        if (packet != null) {
            _log.warn("unexpected client packet (type={}) after server finished the session; discarding incoming data until client closes.", (Object)packet.getType());
            while ((packet = this.readPacket()) != null) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        boolean isActive;
        Object object = this._closeLock;
        synchronized (object) {
            isActive = this._isActive;
        }
        return isActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void confirmed() throws IOException {
        _log.debug("confirmed(closing={}; closed={})", (Object)this._closing, (Object)this._closed);
        if (this._mode == 1) {
            Object object = this._closeLock;
            synchronized (object) {
                if (!this._closed && this._closing) {
                    this._closed = true;
                    this._closing = false;
                    this._socket.close();
                }
            }
        }
        Object object = this._closeLock;
        synchronized (object) {
            if (!this._closed) {
                this._closed = true;
                this._socket.close();
            }
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void client_loop() throws IOException, SshAuthenticationException {
        state = 0;
        sessionId = null;
        identity = null;
        block18: while (true) {
            if ((packet = this.readPacket()) == null) {
                return;
            }
            packetType = packet.getType();
            SshStreamEngine._log.debug("Packet arrived: " + packetType);
            switch (packet.getType()) {
                case 36: {
                    debug = new SshMsgDebug(packet);
                    SshStreamEngine._log.debug("SSH_MSG_DEBUG: {}", (Object)debug.getMessage());
                    ** break;
                }
                case 2: {
                    SshStreamEngine._log.debug("SSH_SMSG_PUBLIC_KEY received");
                    publicKey = new SshSmsgPublicKey(packet);
                    if (!this._clientAuth.isHostKey(this._socket.getInetAddress(), publicKey.getHostKey())) {
                        throw new SshAuthenticationException("Unknown Host key");
                    }
                    sessionId = publicKey.getSessionId();
                    sessionKey = new byte[32];
                    r = new Random(new Date().getTime());
                    r.nextBytes(sessionKey);
                    remSessionKey = new byte[32];
                    System.arraycopy(sessionKey, 0, remSessionKey, 0, sessionKey.length);
                    for (i = 0; i < 16; ++i) {
                        v0 = i;
                        remSessionKey[v0] = (byte)(remSessionKey[v0] ^ sessionId[i]);
                    }
                    encrypted = publicKey.getHostKey().encrypt(publicKey.getServerKey().encrypt(remSessionKey));
                    SshStreamEngine._log.debug("Sending SshCmsgSessionKey");
                    this.writePacket(new SshCmsgSessionKey(1, publicKey.getCookie(), encrypted, 0));
                    ideakey = new byte[16];
                    System.arraycopy(sessionKey, 0, ideakey, 0, 16);
                    this.setEncryption(1, ideakey);
                    state = 5;
                    ** break;
                }
                case 7: {
                    if (state != 7 && state != 11) {
                        throw new SshProtocolException("PANIC : SSH_SMSG_AUTH_RSA_CHALLENGE in state " + state);
                    }
                    challenge = new SshSmsgAuthRsaChallenge(packet);
                    cBytes = challenge.getMpInt();
                    cBytes = identity.decrypt(cBytes);
                    SshStreamEngine._log.debug("SSH_SMSG_AUTH_RSA_CHALLENGE received");
                    try {
                        md5 = new Md5();
                        md5.update(cBytes);
                        md5.update(sessionId);
                        cBytes = md5.digest();
                    }
                    catch (Exception eee) {
                        SshStreamEngine._log.warn("Ignored exception: {}", (Object)eee.toString());
                    }
                    this.writePacket(new SshCmsgAuthRsaResponse(cBytes));
                    state = 8;
                    ** break;
                }
                case 14: {
                    switch (state) {
                        case 5: {
                            SshStreamEngine._log.debug("SSH_SMSG_SUCCESS on ST_SESSION_SEND");
                            this.writePacket(new SshCmsgUser(this._clientAuth.getUser()));
                            state = 6;
                            ** break;
                        }
                        case 8: {
                            SshStreamEngine._log.debug("SSH_SMSG_SUCCESS on ST_RSA_RESPONSE");
                            this.writePacket(new SshCmsgExecShell());
                            return;
                        }
                        case 10: {
                            SshStreamEngine._log.debug("SSH_SMSG_SUCCESS on ST_TRY_PASSWORD_AUTH");
                            this.writePacket(new SshCmsgExecShell());
                            return;
                        }
                    }
                    throw new SshProtocolException("PANIC : SSH_SMSG_SUCCESS in state " + state);
                }
                case 15: {
                    switch (state) {
                        case 6: 
                        case 7: 
                        case 8: 
                        case 10: 
                        case 11: {
                            SshStreamEngine._log.debug("SSH_SMSG_FAILURE on {}", (Object)state);
                            method = this._clientAuth.getAuthMethod();
                            if (method == null) {
                                throw new SshAuthenticationException("No more methods from Client");
                            }
                            if (method instanceof SshAuthRsa) {
                                identity = method.getKey();
                                modulus = identity.getModulusBytes();
                                bits = identity.getModulusBits();
                                this.writePacket(new SshCmsgAuthRsa(modulus, 0, bits));
                                state = 7;
                                SshStreamEngine._log.debug("Sending ST_TRY_RSA_AUTH");
                                ** break;
                            }
                            if (method instanceof SshAuthRhostsRsa) {
                                identity = method.getKey();
                                this.writePacket(new SshCmsgAuthRhostsRsa(method.getUser(), identity));
                                state = 11;
                                SshStreamEngine._log.debug("Sending ST_TRY_RSA_RHOSTS_AUTH");
                                ** break;
                            }
                            if (!(method instanceof SshAuthPassword)) {
                                throw new SshProtocolException("Illegal class from Client");
                            }
                            this.writePacket(new SshCmsgAuthPassword(method.getUser()));
                            SshStreamEngine._log.debug("Sending ST_TRY_PASSWORD_AUTH");
                            state = 10;
                            ** break;
                        }
                    }
                    throw new SshProtocolException("PANIC : SSH_SMSG_FAILURE in state " + state);
                }
                default: {
                    SshStreamEngine._log.warn("Unknown denied: " + packet.getType());
lbl102:
                    // 8 sources

                    continue block18;
                }
                case 1: 
            }
            break;
        }
        SshStreamEngine._log.debug("SSH_MSG_DISCONNECT: not implemented");
    }

    private void server_loop() throws IOException {
        SshPacket packet;
        SshSmsgFailure bad = new SshSmsgFailure();
        SshSmsgSuccess ok = new SshSmsgSuccess();
        byte[] challenge = null;
        int state = 0;
        block18: while ((packet = this.readPacket()) != null) {
            switch (packet.getType()) {
                case 1: {
                    _log.debug("SSH_MSG_DISCONNECT");
                    return;
                }
                case 36: {
                    SshMsgDebug debug = new SshMsgDebug(packet);
                    _log.debug("SSH_MSG_DEBUG: {}", (Object)debug.getMessage());
                    break;
                }
                case 6: {
                    _log.debug("SSH_CMSG_AUTH_RSA");
                    SshPacket rsa = new SshCmsgAuthRsa(packet);
                    SshRsaKey userKey = this._serverAuth.authRsa(this._remoteAddress, this.getName(), ((SshCmsgAuthRsa)rsa).getKey());
                    if (userKey == null) {
                        _log.warn("SSH_CMSG_AUTH_RSA: Key not found");
                        this.writePacket(bad);
                        break;
                    }
                    _log.debug("SSH_CMSG_AUTH_RSA: Key found");
                    Random r = new Random(System.currentTimeMillis());
                    challenge = new byte[32];
                    r.nextBytes(challenge);
                    BigInteger bi = userKey.encryptBigInteger(challenge, 0, challenge.length);
                    this.writePacket(new SshSmsgAuthRsaChallenge(bi.toByteArray(), 0, bi.bitLength()));
                    break;
                }
                case 35: {
                    _log.debug("SSH_CMSG_AUTH_RHOSTS_RSA");
                    SshPacket rsa = new SshCmsgAuthRhostsRsa(packet);
                    SshRsaKey hostKey = this._serverAuth.authRhostsRsa(this._remoteAddress, this.getName(), ((SshCmsgAuthRhostsRsa)rsa).getUserName(), ((SshCmsgAuthRhostsRsa)rsa).getKey());
                    if (hostKey == null) {
                        _log.warn("SSH_CMSG_AUTH_RSA: Key not found");
                        this.writePacket(bad);
                        break;
                    }
                    _log.debug("SSH_CMSG_AUTH_RSA: Key found {}", (Object)hostKey);
                    Random r = new Random(System.currentTimeMillis());
                    challenge = new byte[32];
                    r.nextBytes(challenge);
                    this.writePacket(new SshSmsgAuthRsaChallenge(hostKey.encrypt(challenge, 0, challenge.length), 0, hostKey.getKeySize()));
                    break;
                }
                case 8: {
                    int k;
                    _log.debug("SSH_CMSG_AUTH_RSA_RESPONSE");
                    SshCmsgAuthRsaResponse rsaresp = new SshCmsgAuthRsaResponse(packet);
                    if (challenge == null) {
                        throw new SshProtocolException("SSH_CMSG_AUTH_RSA_RESPONSE challenge not found");
                    }
                    byte[] response = rsaresp.getResponse();
                    if (response.length != 16) {
                        _log.warn("SSH_CMSG_AUTH_RSA_RESPONSE: response != 16 ({} bytes)", (Object)response.length);
                        this.writePacket(bad);
                        break;
                    }
                    Md5 digest = new Md5();
                    digest.update(challenge);
                    digest.update(this._sessionId);
                    byte[] res = digest.digest();
                    for (k = 0; k < res.length && res[k] == response[k]; ++k) {
                    }
                    if (k == 16) {
                        _log.debug("SSH_CMSG_AUTH_RSA_RESPONSE: O.K.");
                        this.writePacket(ok);
                        state = 3;
                        break;
                    }
                    _log.debug("SSH_CMSG_AUTH_RSA_RESPONSE: failed");
                    this.writePacket(bad);
                    break;
                }
                case 3: {
                    _log.debug("SSH_CMSG_SESSION_KEY");
                    if (state != 0) {
                        throw new SshProtocolException("SSH_CMSG_SESSION_KEY in not INIT state");
                    }
                    SshCmsgSessionKey session = new SshCmsgSessionKey(this._serverIdentity, this._hostIdentity, packet);
                    byte[] sessionKey = session.getSessionKey();
                    for (int i = 0; i < 16; ++i) {
                        int n = i;
                        sessionKey[n] = (byte)(sessionKey[n] ^ this._sessionId[i]);
                    }
                    if (!this.setEncryption(session.getCipher(), sessionKey)) {
                        this.writePacket(bad);
                        throw new SshProtocolException("Cipher : can't use " + session.getCipher());
                    }
                    this.writePacket(ok);
                    state = 1;
                    break;
                }
                case 4: {
                    _log.debug("SSH_CMSG_USER: arrived");
                    if (state != 1) {
                        throw new SshProtocolException("SSH_CMSG_USER in not USER state");
                    }
                    SshCmsgUser user = new SshCmsgUser(packet);
                    _log.debug("SSH_CMSG_USER: User = {}", (Object)user.getUser());
                    UserNamePrincipal principal = new UserNamePrincipal(user.getUser());
                    this._remoteUser = new Subject();
                    this._remoteUser.getPrincipals().add((Principal)principal);
                    if (this._serverAuth.authUser(this._remoteAddress, this.getName())) {
                        state = 3;
                        this.writePacket(ok);
                        break;
                    }
                    state = 2;
                    this.writePacket(bad);
                    break;
                }
                case 9: {
                    _log.debug("SSH_CMSG_AUTH_PASSWORD: arrived");
                    if (state != 2) {
                        throw new SshProtocolException("SSH_CMSG_AUTH_PASSWORD in not ST_AUTH state");
                    }
                    SshCmsgAuthPassword psw = new SshCmsgAuthPassword(packet);
                    if (this._serverAuth.authPassword(this._remoteAddress, this.getName(), psw.getPassword())) {
                        this.writePacket(ok);
                        state = 3;
                        break;
                    }
                    this.writePacket(bad);
                    break;
                }
                case 10: {
                    if (state != 3) {
                        throw new SshProtocolException("SSH_CMSG_REQUEST_PTY in not ST_PREPARE state");
                    }
                    SshCmsgRequestPty requestPty = new SshCmsgRequestPty(packet);
                    this._terminal = requestPty.getTerminal();
                    this._height = requestPty.getHeight();
                    this._width = requestPty.getWidth();
                    this.writePacket(ok);
                    _log.debug("SSH_CMSG_REQUEST_PTY: o.k.");
                    break;
                }
                case 11: {
                    SshCmsgWindowSize requestWindowSize = new SshCmsgWindowSize(packet);
                    this._height = requestWindowSize.getHeight();
                    this._width = requestWindowSize.getWidth();
                    this.writePacket(ok);
                    _log.debug("SSH_CMSG_WINDOW_SIZE: o.k.");
                    break;
                }
                case 34: {
                    if (state != 3) {
                        throw new SshProtocolException("SSH_CMSG_X11_REQUEST_FORWARDING in not ST_PREPARE state");
                    }
                    this.writePacket(ok);
                    _log.debug("SSH_CMSG_REQUEST_FORWARDING: o.k.");
                    break;
                }
                case 12: {
                    if (state != 3) {
                        throw new SshProtocolException("SSH_CMSG_EXEC_SHELL in not ST_PREPARE state");
                    }
                    _log.debug("SSH_CMSG_EXEC_SHELL: o.k.");
                    state = 4;
                    return;
                }
                case 13: {
                    if (state != 3) {
                        throw new SshProtocolException("SSH_CMSG_EXEC_CMD in not ST_PREPARE state");
                    }
                    _log.debug("SSH_CMSG_EXEC_CMD: {}", (Object)new SshCmsgExecCmd(packet));
                    state = 4;
                    return;
                }
                case 33: {
                    _log.debug("SSH_CMSG_EXIT_CONFORMATION: o.k.");
                    break;
                }
                case 16: {
                    throw new SshProtocolException("SSH_CMSG_STDIN_DATA while preparing (FATAL)");
                }
                case 30: {
                    this.writePacket(bad);
                    break;
                }
                default: {
                    _log.warn("Unknown denied : {}", (Object)packet.getType());
                    if (state == 4) continue block18;
                    this.writePacket(bad);
                }
            }
        }
    }
}

