/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.telnet;

import dmg.protocols.telnet.TelnetAuthenticationException;
import dmg.protocols.telnet.TelnetInputStream2;
import dmg.protocols.telnet.TelnetInputStreamReader;
import dmg.protocols.telnet.TelnetOutputStream2;
import dmg.protocols.telnet.TelnetOutputStreamWriter;
import dmg.protocols.telnet.TelnetServerAuthentication;
import dmg.util.DummyStreamEngine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.security.Principal;
import javax.security.auth.Subject;
import org.dcache.auth.UserNamePrincipal;

public class TelnetStreamEngine
extends DummyStreamEngine {
    private static final byte telnetSE = -16;
    private static final byte telnetNOP = -15;
    private static final byte telnetDM = -14;
    private static final byte telnetBRK = -13;
    private static final byte telnetIP = -12;
    private static final byte telnetAO = -11;
    private static final byte telnetAYT = -10;
    private static final byte telnetEC = -9;
    private static final byte telnetEL = -8;
    private static final byte telnetGA = -7;
    private static final byte telnetSB = -6;
    private static final byte telnetWILL = -5;
    private static final byte telnetWONT = -4;
    private static final byte telnetDO = -3;
    private static final byte telnetDONT = -2;
    private static final byte telnetIAC = -1;
    private static final byte telnetCR = 13;
    private static final byte telnetLF = 10;
    private static final byte telnetNUL = 0;
    private static final byte telnetOptionEcho = 1;
    private static final byte telnetOptionLine = 3;
    private static final int cctData = 1;
    private static final int cctCR = 2;
    private static final int cctCR2 = 3;
    private static final int cctCT1 = 4;
    private static final int cctCT2 = 5;
    private static final int cctSUB = 6;
    private static final int cctESC = 7;
    public static final byte[] telnetBN = new byte[]{13, 10};
    private final byte[] willEcho = new byte[]{-1, -5, 3, -1, -5, 1};
    private final byte[] wontEcho = new byte[]{-1, -4, 3, -1, -4, 1};
    private int _engineState;
    private int _controlDataPos;
    private byte[] _controlData;
    boolean _lineMode = true;
    boolean _echoMode = true;
    boolean _passwordMode;
    private TelnetServerAuthentication _serverAuth;
    private OutputStream _outputStream;
    private InputStream _inputStream;
    private TelnetInputStream2 _telnetInputStream;
    private TelnetOutputStream2 _telnetOutputStream;
    private TelnetInputStreamReader _reader;
    private TelnetOutputStreamWriter _writer;

    public TelnetStreamEngine(Socket socket, TelnetServerAuthentication auth) throws IOException, TelnetAuthenticationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        super(socket);
        this._serverAuth = auth;
        this._engineState = 0;
        this._controlData = null;
        this._controlDataPos = 0;
        this._inputStream = super.getInputStream();
        this._outputStream = super.getOutputStream();
        this._telnetInputStream = new TelnetInputStream2(this);
        this._telnetOutputStream = new TelnetOutputStream2(this);
        this._writer = new TelnetOutputStreamWriter(this._telnetOutputStream);
        this._reader = new TelnetInputStreamReader((InputStream)this._telnetInputStream, this._writer);
        try {
            Method meth = socket.getClass().getMethod("verify", new Class[0]);
            boolean verified = (Boolean)meth.invoke((Object)socket, new Object[0]);
            if (!verified) {
                String hostAddress = socket.getInetAddress().getHostAddress();
                socket.close();
                throw new TelnetAuthenticationException("Host " + hostAddress + ": Tunnel verification failed!");
            }
            meth = socket.getClass().getMethod("getSubject", new Class[0]);
            Subject subject = (Subject)meth.invoke((Object)socket, new Object[0]);
            this.setSubject(subject);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (this._serverAuth != null) {
            this.doAuthentication();
        }
    }

    @Override
    public Reader getReader() {
        return this._reader;
    }

    @Override
    public Writer getWriter() {
        return this._writer;
    }

    @Override
    public InputStream getInputStream() {
        return this._telnetInputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this._telnetOutputStream;
    }

    public void setEcho(boolean echo) throws IOException {
        this._outputStream.write(echo ? this.wontEcho : this.willEcho);
        this._outputStream.flush();
    }

    public void setPasswordMode(boolean p) throws IOException {
        this._passwordMode = p;
        this.setEcho(!p);
    }

    void close() throws IOException {
        this.getSocket().close();
    }

    int read() throws IOException {
        Object obj;
        while ((obj = this.readNext()) != null) {
            if (obj instanceof Byte) {
                int b = ((Byte)obj).intValue();
                int n = b = b == 13 ? 10 : b;
                if (!this._echoMode && !this._passwordMode) {
                    this.write(b);
                }
                return b;
            }
            if (!(obj instanceof byte[])) continue;
            this._handleControl((byte[])obj);
        }
        return -1;
    }

    void write(int c) throws IOException {
        if (c == 10) {
            this._outputStream.write(13);
            this._outputStream.write(10);
        } else {
            this._outputStream.write(c);
        }
    }

    private void doAuthentication() throws TelnetAuthenticationException, IOException {
        InetAddress host = this.getInetAddress();
        if (this._serverAuth.isHostOk(host)) {
            return;
        }
        this.setEcho(true);
        this._writer.write("\n      User : ");
        this._writer.flush();
        BufferedReader r = new BufferedReader(this._reader);
        String user = r.readLine();
        if (this._serverAuth.isUserOk(host, user)) {
            UserNamePrincipal principal = new UserNamePrincipal(user);
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)principal);
            this.setSubject(subject);
            return;
        }
        this.setPasswordMode(true);
        this._writer.write("  Password : ");
        this._writer.flush();
        String password = r.readLine();
        if (this._serverAuth.isPasswordOk(host, user, password)) {
            this.setPasswordMode(false);
            UserNamePrincipal principal = new UserNamePrincipal(user);
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)principal);
            this.setSubject(subject);
            this._writer.write("\n\n");
            this._writer.flush();
            return;
        }
        this._writer.write("\n\n !!! Access Denied !!! \n");
        this._writer.flush();
        this.close();
        throw new TelnetAuthenticationException("Not authenticated (host=" + host + ";user=" + user + ")");
    }

    private void _handleControl(byte[] cntr) throws IOException {
        if (cntr.length == 3) {
            switch (cntr[1]) {
                case -2: {
                    switch (cntr[2]) {
                        case 3: {
                            this._lineMode = true;
                            break;
                        }
                        case 1: {
                            this._echoMode = true;
                        }
                    }
                    this._writer.flush();
                    cntr[1] = -4;
                    this._outputStream.write(cntr);
                    this._outputStream.flush();
                    break;
                }
                case -3: {
                    switch (cntr[2]) {
                        case 3: {
                            this._lineMode = false;
                            break;
                        }
                        case 1: {
                            this._echoMode = false;
                        }
                    }
                    this._writer.flush();
                    cntr[1] = -5;
                    this._outputStream.write(cntr);
                    this._outputStream.flush();
                }
            }
        }
    }

    private void _engineControlAdd(byte c) {
        if (this._controlDataPos >= this._controlData.length) {
            this._controlDataPos = 0;
        }
        this._controlData[this._controlDataPos++] = c;
    }

    private void _engineControlClear() {
        if (this._controlData == null) {
            this._controlData = new byte[32];
        }
        this._controlDataPos = 0;
    }

    private byte[] _engineControlGet() {
        if (this._controlDataPos == 0) {
            return null;
        }
        byte[] rc = new byte[this._controlDataPos];
        System.arraycopy(this._controlData, 0, rc, 0, this._controlDataPos);
        this._engineControlClear();
        return rc;
    }

    private Object readNext() throws IOException {
        int rc;
        Object obj;
        do {
            if ((rc = this._inputStream.read()) >= 0) continue;
            return null;
        } while ((obj = this._next((byte)rc)) == null);
        return obj;
    }

    private Object _next(byte c) {
        if (this._engineState == 0) {
            this._engineControlClear();
            this._engineState = 1;
        }
        switch (this._engineState) {
            case 1: {
                if (c == -1) {
                    this._engineState = 4;
                    break;
                }
                if (c == 13) {
                    this._engineState = 2;
                    break;
                }
                return c;
            }
            case 4: {
                if (c == -1) {
                    this._engineState = 1;
                    return c;
                }
                if (c == -6) {
                    this._engineState = 6;
                    this._engineControlAdd((byte)-1);
                    this._engineControlAdd(c);
                    break;
                }
                this._engineState = 5;
                this._engineControlAdd((byte)-1);
                this._engineControlAdd(c);
                break;
            }
            case 5: {
                this._engineState = 1;
                this._engineControlAdd(c);
                return this._engineControlGet();
            }
            case 6: {
                if (c == -1) {
                    this._engineState = 7;
                    break;
                }
                this._engineControlAdd(c);
                break;
            }
            case 7: {
                if (c == -16) {
                    this._engineState = 1;
                    this._engineControlAdd((byte)-1);
                    this._engineControlAdd(c);
                    return this._engineControlGet();
                }
                this._engineState = 6;
                this._engineControlAdd((byte)-1);
                this._engineControlAdd(c);
                break;
            }
            case 2: {
                this._engineState = 3;
                return (byte)10;
            }
            case 3: {
                if (c == -1) {
                    this._engineState = 4;
                    break;
                }
                if (c == 13) {
                    this._engineState = 2;
                    break;
                }
                this._engineState = 1;
                return c;
            }
        }
        return null;
    }

    public void flush() throws IOException {
        this._outputStream.flush();
    }
}

