/*
 * Decompiled with CFR 0.152.
 */
package dmg.security.cipher.pgp;

import dmg.security.cipher.pgp.PGPKeyCertificate;
import dmg.security.cipher.pgp.PGPPacket;
import dmg.security.cipher.pgp.PGPSecretKeyCertificate;
import dmg.security.cipher.pgp.PGPUserIdPacket;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class PGPInputStream
extends FilterInputStream {
    private DataInputStream _input = new DataInputStream(new BufferedInputStream(this));

    public PGPInputStream(InputStream in) {
        super(in);
    }

    public PGPPacket readPGPPacket() throws IOException {
        PGPPacket pgp;
        while ((pgp = this._readPGPPacket()) == null) {
        }
        return pgp;
    }

    private PGPPacket _readPGPPacket() throws IOException {
        PGPPacket pgpPacket;
        int length;
        int type;
        int ctb;
        block13: {
            ctb = this._input.readUnsignedByte();
            if ((ctb & 0x80) == 0) {
                throw new IOException("NOT a Cipher Type Byte");
            }
            try {
                type = ctb >>> 2 & 0xF;
                int lengthLength = ctb & 3;
                if (lengthLength == 0) {
                    length = this._input.readUnsignedByte();
                    break block13;
                }
                if (lengthLength == 1) {
                    length = this._input.readUnsignedShort();
                    break block13;
                }
                if (lengthLength == 2) {
                    length = this._input.readInt();
                    break block13;
                }
                throw new IOException("can't lengthLength = " + lengthLength);
            }
            catch (EOFException eof) {
                throw new IOException("Premature EOF Encountered");
            }
        }
        switch (type) {
            case 5: {
                pgpPacket = this._readSecretKeyCertificate(ctb, length);
                break;
            }
            case 6: {
                pgpPacket = this._readPublicKeyCertificate(ctb, length);
                break;
            }
            case 13: {
                pgpPacket = this._readUserIdPacket(ctb, length);
                break;
            }
            default: {
                try {
                    this._input.skipBytes(length);
                    return null;
                }
                catch (IOException ioe) {
                    throw new IOException("Premature EOF Encountered");
                }
            }
        }
        return pgpPacket;
    }

    private PGPPacket _readUserIdPacket(int ctb, int length) throws IOException {
        byte[] data = new byte[length];
        this._input.readFully(data);
        return new PGPUserIdPacket(ctb, new String(data));
    }

    private PGPPacket _readPublicKeyCertificate(int ctb, int length) throws IOException {
        int version = this._input.readUnsignedByte();
        if (version != 3) {
            throw new IOException("Unsupported format version" + version);
        }
        int timestamp = this._input.readInt();
        int validity = this._input.readUnsignedShort();
        int publicAlgorithm = this._input.readUnsignedByte();
        if (publicAlgorithm != 1) {
            throw new IOException("Can't read Non RSA " + publicAlgorithm);
        }
        PGPKeyCertificate k = new PGPKeyCertificate(ctb, version, timestamp, validity, publicAlgorithm);
        BigInteger n = this.readMPI();
        BigInteger e = this.readMPI();
        k.setPublic(n, e);
        return k;
    }

    private PGPPacket _readSecretKeyCertificate(int ctb, int length) throws IOException {
        int version = this._input.readUnsignedByte();
        if (version != 3) {
            throw new IOException("Unsupported format version" + version);
        }
        int timestamp = this._input.readInt();
        int validity = this._input.readUnsignedShort();
        int publicAlgorithm = this._input.readUnsignedByte();
        if (publicAlgorithm != 1) {
            throw new IOException("Can't read Non RSA " + publicAlgorithm);
        }
        PGPSecretKeyCertificate k = new PGPSecretKeyCertificate(ctb, version, timestamp, validity, publicAlgorithm);
        BigInteger n = this.readMPI();
        BigInteger e = this.readMPI();
        k.setPublic(n, e);
        int secretAlgorithm = this._input.readUnsignedByte();
        if (secretAlgorithm != 0) {
            throw new IOException("Can't decrypt sa : " + secretAlgorithm);
        }
        BigInteger d = this.readMPI();
        BigInteger p = this.readMPI();
        BigInteger q = this.readMPI();
        BigInteger u = this.readMPI();
        int checkSum = this._input.readUnsignedShort();
        k.setPrivate(d, p, q, u);
        return k;
    }

    private BigInteger readMPI() throws IOException {
        int len = this._input.readUnsignedShort();
        byte[] data = new byte[len = len / 8 + (len % 8 != 0 ? 1 : 0)];
        int rc = this._input.read(data);
        if (rc < len) {
            throw new IOException("Premature EOF encountered(2) " + rc + "<" + len);
        }
        try {
            return new BigInteger(1, data);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Not a BigInteger");
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println(" USAGE : ... <secretKeyRing> ");
            System.exit(4);
        }
        String filename = args[0];
        try {
            PGPPacket pgp;
            PGPInputStream pgpInput = new PGPInputStream(new FileInputStream(filename));
            while ((pgp = pgpInput.readPGPPacket()) != null) {
                PGPKeyCertificate s;
                if (pgp instanceof PGPSecretKeyCertificate) {
                    s = (PGPSecretKeyCertificate)pgp;
                    System.out.println(((PGPSecretKeyCertificate)s).toString());
                    continue;
                }
                if (pgp instanceof PGPKeyCertificate) {
                    s = (PGPKeyCertificate)pgp;
                    System.out.println(s.toString());
                    continue;
                }
                if (pgp instanceof PGPUserIdPacket) {
                    System.out.println(pgp.toString());
                    continue;
                }
                System.out.println(" Don't know : " + pgpInput.getClass().toString());
            }
        }
        catch (IOException ioe) {
            System.out.println(" Exception : " + ioe);
        }
    }
}

