/*
 * Decompiled with CFR 0.152.
 */
package dmg.security.cipher.pgp;

import dmg.security.cipher.EncryptionKey;
import dmg.security.cipher.EncryptionKeyInputStream;
import dmg.security.cipher.pgp.PGPInputStream;
import dmg.security.cipher.pgp.PGPKeyCertificate;
import dmg.security.cipher.pgp.PGPPacket;
import dmg.security.cipher.pgp.PGPSecretKeyCertificate;
import dmg.security.cipher.pgp.PGPUserIdPacket;
import dmg.security.cipher.rsa.RsaEncryptionKey;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PgpKeyInputStream
extends PGPInputStream
implements EncryptionKeyInputStream {
    private static final int IDLE = 0;
    private static final int CERTIFICATE_FOUND = 1;
    private static final int PUBLIC_LEFT = 2;
    private int _state = 0;
    private PGPPacket _key;
    private String[] _domainList;

    public PgpKeyInputStream(InputStream in) {
        super(in);
    }

    @Override
    public EncryptionKey readEncryptionKey() throws IOException {
        while (true) {
            switch (this._state) {
                case 0: {
                    PGPPacket pgp;
                    try {
                        pgp = this.readPGPPacket();
                        if (pgp == null) {
                            return null;
                        }
                    }
                    catch (EOFException eof) {
                        return null;
                    }
                    if (!(pgp instanceof PGPKeyCertificate)) break;
                    this._state = 1;
                    this._key = pgp;
                    break;
                }
                case 1: {
                    PGPPacket pgp;
                    try {
                        pgp = this.readPGPPacket();
                        if (pgp == null) {
                            return null;
                        }
                    }
                    catch (EOFException eof) {
                        return null;
                    }
                    if (pgp instanceof PGPKeyCertificate) {
                        this._state = 1;
                        this._key = pgp;
                        break;
                    }
                    if (!(pgp instanceof PGPUserIdPacket)) break;
                    this._domainList = new String[1];
                    this._domainList[0] = ((PGPUserIdPacket)pgp).getId();
                    this._state = 2;
                    if (!(this._key instanceof PGPSecretKeyCertificate)) break;
                    PGPSecretKeyCertificate privateKey = (PGPSecretKeyCertificate)this._key;
                    return new RsaEncryptionKey(this._domainList, "private", privateKey.getD(), privateKey.getN());
                }
                case 2: {
                    this._state = 0;
                    PGPKeyCertificate publicKey = (PGPKeyCertificate)this._key;
                    return new RsaEncryptionKey(this._domainList, "public", publicKey.getE(), publicKey.getN());
                }
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println(" USAGE : ... pgp2mixed <secretKeyRing>");
            System.exit(4);
        }
        if (args[0].equals("pgp2mixed")) {
            String filename = args[1];
            try {
                RsaEncryptionKey key;
                PgpKeyInputStream pgpInput = new PgpKeyInputStream(new FileInputStream(filename));
                while ((key = (RsaEncryptionKey)pgpInput.readEncryptionKey()) != null) {
                    String[] domainList = key.getDomainList();
                    for (int i = 0; i < domainList.length; ++i) {
                        System.out.print(domainList[i]);
                        if (i < domainList.length - 1) break;
                        System.out.print(",");
                    }
                    System.out.print(" " + key.getKeyType() + "," + key.getKeyMode() + " ");
                    System.out.print(key.getExponent().toString(16) + " " + key.getModulus().toString(16) + "\n");
                }
            }
            catch (IOException ioe) {
                System.err.println(" Exception : " + ioe);
                System.exit(1);
            }
        } else {
            System.err.println(" USAGE : ... pgp2mixed <secretKeyRing>");
            System.exit(4);
        }
    }
}

