/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import dmg.util.ExpiredException;
import java.util.Vector;

public class GateKeeper {
    private Vector<ThreadWatch> _stack = new Vector();
    private ThreadWatch _activeThread;
    private int _defaultPrio = 6;
    public static final int MASTER = 0;
    public static final int HIGH = 2;
    public static final int MEDIUM = 4;
    public static final int LOW = 6;

    public GateKeeper() {
    }

    public GateKeeper(int defaultPriority) {
        this._defaultPrio = defaultPriority;
    }

    public synchronized void open(int priority) throws InterruptedException {
        try {
            this.open(priority, 0L);
        }
        catch (ExpiredException expiredException) {
            // empty catch block
        }
    }

    public synchronized void open(int priority, long waitMillis) throws InterruptedException, ExpiredException {
        if (this._activeThread != null && this._activeThread.getThread() == Thread.currentThread()) {
            this._activeThread.increment();
            return;
        }
        ThreadWatch newTw = new ThreadWatch(Thread.currentThread(), priority);
        if (this._activeThread == null) {
            this._activeThread = newTw;
            return;
        }
        this.register(newTw, priority);
        try {
            if (waitMillis > 0L) {
                long stopIt = waitMillis + System.currentTimeMillis();
                do {
                    long rest;
                    if ((rest = stopIt - System.currentTimeMillis()) <= 0L) {
                        this.unregister();
                        throw new ExpiredException("Open timeout expired");
                    }
                    this.wait(rest);
                } while (this._activeThread != null || newTw != this._stack.elementAt(0));
            } else {
                do {
                    this.wait();
                } while (this._activeThread != null || newTw != this._stack.elementAt(0));
            }
        }
        catch (InterruptedException ie) {
            this.unregister();
            throw ie;
        }
        this._activeThread = this._stack.elementAt(0);
        this._stack.removeElementAt(0);
    }

    private void register(ThreadWatch newTw, int priority) {
        int i;
        int c = this._stack.size();
        for (i = 0; i < c; ++i) {
            if (this._stack.elementAt(i).getPriority() <= priority) continue;
            this._stack.insertElementAt(newTw, i);
            break;
        }
        if (i == c) {
            this._stack.addElement(newTw);
        }
    }

    private void unregister() {
        int c = this._stack.size();
        Thread ich = Thread.currentThread();
        for (int i = 0; i < c; ++i) {
            ThreadWatch tw = this._stack.elementAt(i);
            if (tw.getThread() != ich) continue;
            this._stack.removeElementAt(i);
            return;
        }
    }

    public synchronized void close() {
        if (this._activeThread == null || Thread.currentThread() != this._activeThread.getThread()) {
            throw new IllegalArgumentException("Not owner");
        }
        if (this._activeThread.decrement() > 0) {
            return;
        }
        this._activeThread = null;
        this.notifyAll();
    }

    private class ThreadWatch {
        private Thread _thread;
        private int _priority;
        private int _usage;

        private ThreadWatch(Thread thread, int priority) {
            this._priority = priority;
            this._thread = thread;
            this._usage = 1;
        }

        public int getPriority() {
            return this._priority;
        }

        public Thread getThread() {
            return this._thread;
        }

        public void increment() {
            ++this._usage;
        }

        public int decrement() {
            --this._usage;
            return this._usage;
        }
    }
}

