/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import dmg.util.StateEngine;
import java.util.Date;

public class StateThread
implements Runnable {
    private StateEngine _engine;
    private Thread _timerThread;
    private Thread _workerThread;
    private Thread _tickerThread;
    private final Object _timerLock = new Object();
    private int _timerTime;
    private int _timerState;
    private int _timeoutState;
    private long _timeStamp;

    public StateThread(StateEngine engine) {
        this._engine = engine;
        this._timeStamp = new Date().getTime();
        this._tickerThread = new Thread(this);
        this._workerThread = new Thread(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this._timerLock;
        synchronized (object) {
            if (this._tickerThread != null) {
                this._tickerThread.interrupt();
            }
            if (this._workerThread != null) {
                this._workerThread.interrupt();
            }
            if (this._timerThread != null) {
                this._timerThread.interrupt();
            }
        }
    }

    public void start() {
        this._workerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _resetTimer() {
        Object object = this._timerLock;
        synchronized (object) {
            if (this._timerThread != null) {
                this._timerThread.interrupt();
                this._timerThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setTimer(int sec) {
        Object object = this._timerLock;
        synchronized (object) {
            this._resetTimer();
            this._timerTime = sec;
        }
    }

    public int setFinalState() {
        return this.setState(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setState(int state) {
        Object object = this._timerLock;
        synchronized (object) {
            if (Thread.currentThread() != this._workerThread) {
                if (this._workerThread != null) {
                    this._workerThread.interrupt();
                }
                this._workerThread = new Thread(this);
                this._workerThread.start();
            }
            this._resetTimer();
            this._timerState = state;
            this._timeoutState = 0;
            long now = new Date().getTime();
            int diff = (int)(now - this._timeStamp);
            this._timeStamp = now;
            return diff;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setState(int state, int to, int toState) {
        Object object = this._timerLock;
        synchronized (object) {
            if (Thread.currentThread() != this._workerThread) {
                if (this._workerThread != null) {
                    this._workerThread.interrupt();
                }
                this._workerThread = new Thread(this);
                this._workerThread.start();
            }
            this._resetTimer();
            this._timerState = state;
            this._timeoutState = toState;
            this._setTimer(to);
            long now = new Date().getTime();
            int diff = (int)(now - this._timeStamp);
            this._timeStamp = now;
            return diff;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        int value;
        Object object = this._timerLock;
        synchronized (object) {
            value = this._timerState;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Thread.currentThread() == this._workerThread) {
            int state = this.getState();
            while (!Thread.interrupted()) {
                if ((state = this._engine.runState(state)) != 0) {
                    this.setState(state);
                } else {
                    state = this.getState();
                }
                if (state >= 0) continue;
                return;
            }
        } else {
            if (Thread.currentThread() == this._tickerThread) {
                int state;
                do {
                    state = this.getState();
                    System.out.println(" Ticker : state = " + state);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                } while (state >= 0);
                return;
            }
            if (Thread.currentThread() == this._timerThread) {
                Object object = this._timerLock;
                synchronized (object) {
                    try {
                        this._timerLock.wait(this._timerTime * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this._workerThread != null) {
                        this._workerThread.interrupt();
                    }
                    this._timerState = this._timeoutState;
                    this._workerThread = new Thread(this);
                    this._workerThread.start();
                }
            }
        }
    }
}

