/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.command;

import dmg.cells.nucleus.DelayedReply;
import dmg.cells.nucleus.Reply;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public abstract class DelayedCommand<T extends Serializable>
extends DelayedReply
implements Callable<Reply>,
Runnable {
    private static final Executor NEW_THREAD_EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable command) {
            new Thread(command).start();
        }
    };
    private final Executor executor;

    protected DelayedCommand() {
        this(NEW_THREAD_EXECUTOR);
    }

    protected DelayedCommand(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Reply call() throws Exception {
        this.executor.execute(this);
        return this;
    }

    protected abstract T execute() throws Exception;

    @Override
    public void run() {
        Object result;
        try {
            result = this.execute();
        }
        catch (Exception e) {
            result = e;
        }
        this.reply((Serializable)result);
    }
}

