/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.edb;

import dmg.util.edb.JdbmSerializable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class JdbmDirectory
implements JdbmSerializable {
    private static final long serialVersionUID = -5850714968851810542L;
    private int _size;
    private long[] _addr;
    private int _bits;

    public JdbmDirectory() {
    }

    public JdbmDirectory(int maxBytes) {
        int offset = 10;
        int n = 8;
        int bits = 3;
        while (offset + n * 8 <= maxBytes) {
            ++bits;
            n *= 2;
        }
        if (n < 8) {
            throw new IllegalArgumentException("Block to small " + maxBytes);
        }
        this._bits = bits - 1;
        this._size = n / 2 * 8;
        this._addr = new long[this._size];
    }

    public void expand() {
        this._size *= 2;
        long[] newAddr = new long[this._size];
        int n = 0;
        int i = 0;
        while (i < this._size) {
            long l = this._addr[n];
            newAddr[i + 1] = l;
            newAddr[i] = l;
            i += 2;
            ++n;
        }
        ++this._bits;
        this._addr = newAddr;
    }

    @Override
    public void writeObject(ObjectOutput out) throws IOException {
        if (this._size > this._addr.length) {
            throw new IllegalArgumentException("PANIC : _size > _addr");
        }
        out.writeInt(this._size);
        for (int i = 0; i < this._size; ++i) {
            out.writeLong(this._addr[i]);
        }
    }

    @Override
    public void readObject(ObjectInput in) throws IOException, ClassNotFoundException {
        this._size = in.readInt();
        this._addr = new long[this._size];
        for (int i = 0; i < this._size; ++i) {
            this._addr[i] = in.readLong();
        }
    }

    public String toString() {
        return "dir{b=" + this._bits + ";e=" + this._size + ";s=" + this.getPersistentSize() + "}";
    }

    @Override
    public int getPersistentSize() {
        return 10 + 8 * this._size;
    }
}

