/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dmg.cells.nucleus.CellNucleus;
import dmg.util.logback.CellThresholdFilterCompanion;
import dmg.util.logback.FilterThresholds;
import dmg.util.logback.LoggerName;
import dmg.util.logback.RootFilterThresholds;
import dmg.util.logback.Threshold;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.slf4j.Marker;

public class CellThresholdFilter
extends TurboFilter {
    private FilterReply _onHigherOrEqual = FilterReply.NEUTRAL;
    private FilterReply _onLower = FilterReply.DENY;
    private final List<Threshold> _thresholds = Lists.newArrayList();

    public void addThreshold(Threshold threshold) {
        Preconditions.checkState((!this.isStarted() ? 1 : 0) != 0, (Object)"Cannot add threshold after start");
        this._thresholds.add(threshold);
    }

    public FilterReply getOnHigherOrEqual() {
        return this._onHigherOrEqual;
    }

    public void setOnHigherOrEqual(FilterReply onHigherOrEqual) {
        Preconditions.checkNotNull((Object)onHigherOrEqual);
        this._onHigherOrEqual = onHigherOrEqual;
    }

    public FilterReply getOnLower() {
        return this._onLower;
    }

    public void setOnLower(FilterReply onLower) {
        Preconditions.checkNotNull((Object)onLower);
        this._onLower = onLower;
    }

    private Set<Appender<ILoggingEvent>> getAppenders(LoggerContext context) {
        HashSet appenders = Sets.newHashSet();
        for (ch.qos.logback.classic.Logger logger : context.getLoggerList()) {
            Iterator i = logger.iteratorForAppenders();
            while (i.hasNext()) {
                Appender appender = (Appender)i.next();
                appenders.add(appender);
            }
        }
        return appenders;
    }

    public void start() {
        LoggerContext context = (LoggerContext)this.getContext();
        for (Appender<ILoggingEvent> appender : this.getAppenders(context)) {
            String appenderName = appender.getName();
            RootFilterThresholds.addAppender(appenderName);
            for (Threshold threshold : this._thresholds) {
                if (!threshold.isApplicableToAppender(appender)) continue;
                RootFilterThresholds.setThreshold(threshold.getLogger(), appenderName, threshold.getLevel());
            }
            CellThresholdFilterCompanion filter = new CellThresholdFilterCompanion(appenderName);
            filter.start();
            appender.addFilter((Filter)filter);
        }
        super.start();
    }

    public FilterReply decide(Marker marker, ch.qos.logback.classic.Logger logger, Level level, String format, Object[] params, Throwable t) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        String cell = MDC.get((String)"cells.cell");
        CellNucleus nucleus = CellNucleus.getLogTargetForCell(cell);
        if (nucleus == null) {
            return FilterReply.NEUTRAL;
        }
        FilterThresholds thresholds = nucleus.getLoggingThresholds();
        if (thresholds == null) {
            return FilterReply.NEUTRAL;
        }
        Level threshold = thresholds.getThreshold(LoggerName.getInstance((Logger)logger));
        if (threshold == null) {
            return FilterReply.NEUTRAL;
        }
        if (level.isGreaterOrEqual(threshold)) {
            return this._onHigherOrEqual;
        }
        return this._onLower;
    }
}

