/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.applets.login;

import dmg.cells.applets.login.DomainConnection;
import dmg.cells.applets.login.DomainConnectionListener;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.Serializable;

public class UserAdminPanel
extends Panel
implements ActionListener,
DomainConnectionListener {
    private static final long serialVersionUID = 2710489975306356589L;
    private TextField _email = new TextField();
    private Button _emailButton = new Button("Change E-mail address");
    private Font _bigFont = new Font("SansSerif", 1, 18);
    private Label _errorLabel = new Label();
    private TextField _user = new TextField();
    private Button _addUser = new Button("Add User");
    private Button _rmUser = new Button("Remove User");
    private PasswordPanel _pwdPanel = new PasswordPanel();
    private DomainConnection _domain;

    public UserAdminPanel(DomainConnection dc) {
        this._domain = dc;
        BorderLayout bl = new BorderLayout();
        bl.setHgap(5);
        bl.setVgap(5);
        this.setLayout(bl);
        this._user.addActionListener(this);
        this._addUser.addActionListener(this);
        this._rmUser.addActionListener(this);
        this._pwdPanel.addActionListener(this);
        this._emailButton.addActionListener(this);
        UserPanel up = new UserPanel();
        EmailPanel ep = new EmailPanel();
        Label topLabel = new Label("User Administration", 1);
        topLabel.setFont(this._bigFont);
        this.add((Component)topLabel, "North");
        Panel l1Panel = new Panel(new BorderLayout());
        this.add((Component)l1Panel, "Center");
        this.add((Component)this._errorLabel, "South");
        this._errorLabel.setBackground(Color.yellow);
        l1Panel.add((Component)up, "North");
        Panel l2Panel = new Panel(new BorderLayout());
        l1Panel.add((Component)l2Panel, "South");
        l2Panel.add((Component)this._pwdPanel, "North");
        Panel l3Panel = new Panel(new BorderLayout());
        l2Panel.add((Component)l3Panel, "South");
        l3Panel.add((Component)ep, "North");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object[] r;
        Object source = event.getSource();
        if (this._user.getText().length() == 0) {
            this._errorLabel.setText("User ????");
            return;
        }
        if (source == this._rmUser) {
            this._errorLabel.setText("");
            return;
        }
        if (source == this._pwdPanel) {
            r = new Object[]{"request", "*", "set-password", this._user.getText(), this._pwdPanel.getText()};
        } else if (source == this._addUser) {
            r = new Object[]{"request", "*", "create-user", this._user.getText()};
        } else if (source == this._user) {
            r = new Object[]{"request", "*", "get-user-attr", this._user.getText()};
        } else if (source == this._emailButton) {
            String[] p = new String[2];
            Object[] a = new Object[]{p};
            p[0] = "e-mail";
            p[1] = this._email.getText();
            r = new Object[]{"request", "*", "set-user-attr", this._user.getText(), a};
        } else {
            return;
        }
        try {
            this._domain.sendObject((Serializable)r, this, 0);
        }
        catch (Exception e) {
            this._errorLabel.setText("E=" + e.getMessage());
        }
    }

    @Override
    public void domainAnswerArrived(Object obj, int id) {
        if (obj instanceof Object[]) {
            this._errorLabel.setText("O.K");
            Object[] array = (Object[])obj;
            if (array.length < 5) {
                return;
            }
            if (array[2].toString().endsWith("et-user-attr")) {
                if (array.length < 5 || !(array[4] instanceof Object[])) {
                    return;
                }
                for (Object anArray : array = (Object[])array[4]) {
                    if (!(anArray instanceof String[]) || !((String[])anArray)[0].equals("e-mail")) continue;
                    this._email.setText(((String[])anArray)[1]);
                    break;
                }
            }
        } else if (obj instanceof Exception) {
            this._errorLabel.setText(((Exception)obj).getMessage());
        } else {
            this._errorLabel.setText(obj.toString());
        }
    }

    private class EmailPanel
    extends Panel
    implements TextListener {
        private static final long serialVersionUID = -2718301361562797444L;
        private int _b = 5;

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getSize();
            g.setColor(Color.white);
            g.drawRect(this._b / 2, this._b / 2, d.width - this._b, d.height - this._b);
        }

        @Override
        public Insets getInsets() {
            return new Insets(this._b, this._b, this._b, this._b);
        }

        public EmailPanel() {
            BorderLayout bl = new BorderLayout();
            bl.setHgap(5);
            bl.setVgap(5);
            this.setLayout(bl);
            GridLayout gl = new GridLayout(0, 1);
            gl.setHgap(5);
            gl.setVgap(5);
            Panel top = new Panel(gl);
            top.add(new Label("E-Mail Address"));
            top.add(UserAdminPanel.this._email);
            top.add(UserAdminPanel.this._emailButton);
            this.add((Component)top, "North");
            UserAdminPanel.this._email.addTextListener(this);
        }

        @Override
        public void textValueChanged(TextEvent event) {
            UserAdminPanel.this._emailButton.setEnabled(UserAdminPanel.this._email.getText().length() > 0 && UserAdminPanel.this._user.getText().length() > 0);
        }
    }

    private class UserPanel
    extends Panel {
        private static final long serialVersionUID = 957179324799939444L;
        private int _b = 5;

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getSize();
            g.setColor(Color.white);
            g.drawRect(this._b / 2, this._b / 2, d.width - this._b, d.height - this._b);
        }

        @Override
        public Insets getInsets() {
            return new Insets(this._b, this._b, this._b, this._b);
        }

        public UserPanel() {
            BorderLayout bl = new BorderLayout();
            bl.setHgap(5);
            bl.setVgap(5);
            this.setLayout(bl);
            GridLayout gl = new GridLayout(1, 0);
            gl.setHgap(5);
            gl.setVgap(5);
            GridLayout gl2 = new GridLayout(1, 0);
            gl2.setHgap(5);
            gl2.setVgap(5);
            Panel top = new Panel(gl);
            Panel bottom = new Panel(gl2);
            top.add(new Label("User Name"));
            top.add(UserAdminPanel.this._user);
            bottom.add(UserAdminPanel.this._addUser);
            bottom.add(UserAdminPanel.this._rmUser);
            this.add((Component)top, "North");
            this.add((Component)bottom, "South");
        }
    }

    private class PasswordPanel
    extends Panel
    implements TextListener,
    ActionListener {
        private static final long serialVersionUID = 6984647158572645558L;
        private int _b = 5;
        private ActionListener _actionListener;
        private TextField _pwd = new TextField();
        private TextField _vpwd = new TextField();
        private Button _okButton = new Button("Change Password");

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getSize();
            g.setColor(Color.white);
            g.drawRect(this._b / 2, this._b / 2, d.width - this._b, d.height - this._b);
        }

        @Override
        public Insets getInsets() {
            return new Insets(this._b, this._b, this._b, this._b);
        }

        public void addActionListener(ActionListener al) {
            this._actionListener = al;
        }

        public PasswordPanel() {
            BorderLayout bl = new BorderLayout();
            bl.setHgap(5);
            bl.setVgap(5);
            this.setLayout(bl);
            GridLayout gl = new GridLayout(2, 2);
            gl.setHgap(5);
            gl.setVgap(5);
            Panel top = new Panel(gl);
            top.add(new Label("New Password"));
            top.add(this._pwd);
            top.add(new Label("Verify Password"));
            top.add(this._vpwd);
            this.add((Component)top, "North");
            this.add((Component)this._okButton, "South");
            this._pwd.addTextListener(this);
            this._vpwd.addTextListener(this);
            this._pwd.setEchoChar('*');
            this._vpwd.setEchoChar('*');
            this._okButton.setEnabled(false);
            this._okButton.addActionListener(this);
        }

        public String getText() {
            return this._pwd.getText();
        }

        @Override
        public void textValueChanged(TextEvent event) {
            this._okButton.setEnabled(this._pwd.getText().length() > 0 && this._vpwd.getText().equals(this._pwd.getText()));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this._actionListener != null) {
                this._actionListener.actionPerformed(new ActionEvent(this, 0, UserAdminPanel.this._pwdPanel.getText()));
            }
            this._pwd.setText("");
            this._vpwd.setText("");
        }
    }
}

