/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.applets.spy;

import dmg.cells.applets.spy.DomainConnection;
import dmg.cells.applets.spy.DomainConnectionEvent;
import dmg.cells.applets.spy.DomainConnectionListener;
import dmg.cells.applets.spy.DomainListPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Properties;

public class Spy
extends Frame
implements WindowListener,
ActionListener,
DomainConnectionListener {
    private static final long serialVersionUID = 2320418362286824232L;
    private DomainConnection _connection;
    private Button _connectButton;
    private Button _closeButton;
    private Label _messageText;
    private Panel _domainListPanel;

    public Spy(String host, int port) {
        super("DomainSpy");
        this._connection = new DomainConnection(host, port);
        this.addWindowListener(this);
        this._connection.addConnectionListener(this);
        this._domainListPanel = new DomainListPanel(this._connection);
        Panel masterPanel = new Panel(new BorderLayout());
        Panel buttonPanel = new Panel(new FlowLayout(1));
        BorderPanel actionPanel = new BorderPanel(this._domainListPanel);
        this._connectButton = new Button("Connect");
        this._closeButton = new Button("Close Connection");
        this._messageText = new Label("Not Connected");
        this._connectButton.addActionListener(this);
        this._closeButton.addActionListener(this);
        buttonPanel.add(this._connectButton);
        buttonPanel.add(this._closeButton);
        masterPanel.add((Component)buttonPanel, "North");
        masterPanel.add((Component)actionPanel, "Center");
        masterPanel.add((Component)this._messageText, "South");
        this.add(masterPanel);
        this.connectionActive(false);
        this.setSize(750, 500);
        this.pack();
        this.setSize(750, 500);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this._connectButton) {
            try {
                this._connection.connect();
            }
            catch (Exception e) {
                this._messageText.setText("Not Connected : " + e.getMessage());
            }
        } else if (source == this._closeButton) {
            this._connection.close();
        }
    }

    @Override
    public void connectionActivated(DomainConnectionEvent event) {
        this.connectionActive(true);
        this._messageText.setText("Connected");
    }

    @Override
    public void connectionDeactivated(DomainConnectionEvent event) {
        System.out.println("Listener : " + event.getMessage());
        this.connectionActive(false);
        this._messageText.setText("Connection Closed : " + event.getMessage());
    }

    @Override
    public void connectionFailed(DomainConnectionEvent event) {
        this._messageText.setText("Connection Failed : " + event.getMessage());
        this.connectionActive(false);
    }

    private void connectionActive(boolean enabled) {
        this._connectButton.setEnabled(!enabled);
        this._closeButton.setEnabled(enabled);
        this._messageText.setBackground(enabled ? Color.green : Color.red);
        this._domainListPanel.setEnabled(enabled);
    }

    @Override
    public void windowOpened(WindowEvent event) {
    }

    @Override
    public void windowClosed(WindowEvent event) {
        System.exit(0);
    }

    @Override
    public void windowClosing(WindowEvent event) {
        System.exit(0);
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage : ... <hostName> <spyListenPort>");
            System.exit(4);
        }
        if (args.length > 2) {
            Properties props = System.getProperties();
            props.put("bw", args[2]);
        }
        int port = Integer.parseInt(args[1]);
        try {
            new Spy(args[0], port);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Connection failed : " + e.toString());
            System.exit(4);
        }
    }

    private class BorderPanel
    extends Panel {
        private static final long serialVersionUID = 3231733834533174912L;

        public BorderPanel(Component c) {
            super(new BorderLayout());
            this.add(c, "Center");
        }

        @Override
        public Insets getInsets() {
            return new Insets(10, 10, 10, 10);
        }
    }
}

