/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.network;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellDomainInfo;
import dmg.cells.nucleus.CellExceptionMessage;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.CellTunnel;
import dmg.cells.nucleus.CellTunnelInfo;
import dmg.cells.nucleus.MessageEvent;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.RoutedMessageEvent;
import dmg.cells.nucleus.SerializationException;
import dmg.util.StreamEngine;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.dcache.util.Args;
import org.dcache.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationMgrTunnel
extends CellAdapter
implements CellTunnel,
Runnable {
    private static final Tunnels _tunnels = new Tunnels();
    private static final Logger _log = LoggerFactory.getLogger(LocationMgrTunnel.class);
    private final CellNucleus _nucleus;
    private CellDomainInfo _remoteDomainInfo;
    private final Socket _socket;
    private final OutputStream _rawOut;
    private final InputStream _rawIn;
    private ObjectSource _input;
    private ObjectSink _output;
    private boolean _down;
    private int _messagesToTunnel;
    private int _messagesToSystem;

    public LocationMgrTunnel(String cellName, StreamEngine engine, Args args) throws IOException {
        super(cellName, "System", args, false);
        try {
            this._nucleus = this.getNucleus();
            this._socket = engine.getSocket();
            this._socket.setTcpNoDelay(true);
            this._rawOut = new BufferedOutputStream(engine.getOutputStream());
            this._rawIn = new BufferedInputStream(engine.getInputStream());
        }
        catch (IOException e) {
            this.start();
            this.kill();
            throw e;
        }
        this.getNucleus().newThread(this, "Tunnel").start();
    }

    private void handshake() throws IOException {
        try {
            ObjectOutputStream out = new ObjectOutputStream(this._rawOut);
            out.writeObject(new CellDomainInfo(this._nucleus.getCellDomainName(), Version.of(LocationMgrTunnel.class).getVersion()));
            out.flush();
            ObjectInputStream in = new ObjectInputStream(this._rawIn);
            this._remoteDomainInfo = (CellDomainInfo)in.readObject();
            if (this._remoteDomainInfo == null) {
                throw new IOException("EOS encountered while reading DomainInfo");
            }
            this._input = new JavaObjectSource(in);
            this._output = new JavaObjectSink(out);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Cannot deserialize object. This is most likely due to a version mismatch.", e);
        }
        _log.debug("Established tunnel to {}", (Object)this.getRemoteDomainName());
    }

    private synchronized void setDown(boolean down) {
        this._down = down;
        this.notifyAll();
    }

    private synchronized boolean isDown() {
        return this._down;
    }

    private void returnToSender(CellMessage msg, NoRouteToCellException e) throws SerializationException {
        try {
            if (!(msg instanceof CellExceptionMessage)) {
                CellPath retAddr = msg.getSourcePath().revert();
                CellExceptionMessage ret = new CellExceptionMessage(retAddr, e);
                ret.setLastUOID(msg.getUOID());
                this._nucleus.sendMessage(ret, true, true);
            }
        }
        catch (NoRouteToCellException f) {
            _log.warn("Unable to deliver message and unable to return it to sender: " + msg);
        }
    }

    private void receive() throws IOException, ClassNotFoundException {
        CellMessage msg;
        while ((msg = this._input.readObject()) != null) {
            try {
                this.sendMessage(msg);
                ++this._messagesToSystem;
            }
            catch (NoRouteToCellException e) {
                this.returnToSender(msg, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isDown()) {
            throw new IllegalStateException("Tunnel has already been closed");
        }
        try {
            this.handshake();
            this.start();
            _tunnels.add(this);
            try {
                this.receive();
            }
            finally {
                _tunnels.remove(this);
            }
        }
        catch (EOFException | InterruptedException e) {
        }
        catch (ClassNotFoundException e) {
            _log.warn("Cannot deserialize object. This is most likely due to a version mismatch.");
        }
        catch (IOException e) {
            _log.warn("Error while reading from tunnel: " + e.getMessage());
        }
        finally {
            this.start();
            this.kill();
        }
    }

    @Override
    public void messageArrived(MessageEvent me) {
        if (me instanceof RoutedMessageEvent) {
            CellMessage msg = me.getMessage();
            try {
                if (this.isDown()) {
                    throw new IOException("Tunnel has been shut down.");
                }
                ++this._messagesToTunnel;
                this._output.writeObject(msg);
            }
            catch (IOException e) {
                _log.warn("Error while sending message: " + e.getMessage());
                this.returnToSender(msg, new NoRouteToCellException("Communication failure. Message could not be delivered."));
                this.kill();
            }
        } else {
            super.messageArrived(me);
        }
    }

    @Override
    public CellTunnelInfo getCellTunnelInfo() {
        return new CellTunnelInfo(this.getCellName(), new CellDomainInfo(this._nucleus.getCellDomainName()), this._remoteDomainInfo);
    }

    protected String getRemoteDomainName() {
        return this._remoteDomainInfo == null ? "" : this._remoteDomainInfo.getCellDomainName();
    }

    @Override
    public String toString() {
        return "Connected to " + this.getRemoteDomainName();
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("Location Mgr Tunnel : " + this.getCellName());
        pw.println("-> Tunnel     : " + this._messagesToTunnel);
        pw.println("-> Domain     : " + this._messagesToSystem);
        pw.println("Peer          : " + this.getRemoteDomainName());
    }

    @Override
    public void cleanUp() {
        _log.info("Closing tunnel to " + this.getRemoteDomainName());
        this.setDown(true);
        try {
            this._socket.shutdownInput();
            this._socket.close();
        }
        catch (IOException e) {
            _log.warn("Failed to close socket: " + e.getMessage());
        }
    }

    public synchronized void join() throws InterruptedException {
        while (!this.isDown()) {
            this.wait();
        }
    }

    private static class JavaObjectSink
    implements ObjectSink {
        private ObjectOutputStream out;

        private JavaObjectSink(ObjectOutputStream out) {
            this.out = out;
        }

        @Override
        public void writeObject(CellMessage message) throws IOException {
            this.out.writeObject(message);
            this.out.reset();
            this.out.flush();
        }
    }

    private static class JavaObjectSource
    implements ObjectSource {
        private ObjectInputStream in;

        private JavaObjectSource(ObjectInputStream in) {
            this.in = in;
        }

        @Override
        public CellMessage readObject() throws IOException, ClassNotFoundException {
            return (CellMessage)this.in.readObject();
        }
    }

    private static interface ObjectSink {
        public void writeObject(CellMessage var1) throws IOException;
    }

    private static interface ObjectSource {
        public CellMessage readObject() throws IOException, ClassNotFoundException;
    }

    private static class Tunnels {
        private Map<String, LocationMgrTunnel> _tunnels = new HashMap<String, LocationMgrTunnel>();

        private Tunnels() {
        }

        public synchronized void add(LocationMgrTunnel tunnel) throws InterruptedException {
            LocationMgrTunnel old;
            CellNucleus nucleus = tunnel.getNucleus();
            if (this._tunnels.containsValue(tunnel)) {
                throw new IllegalArgumentException("Cannot register the same tunnel twice");
            }
            String domain = tunnel.getRemoteDomainName();
            while ((old = this._tunnels.get(domain)) != null) {
                old.kill();
                this.wait();
            }
            CellRoute route = new CellRoute(domain, tunnel.getCellName(), 3);
            try {
                nucleus.routeAdd(route);
            }
            catch (IllegalArgumentException e) {
                nucleus.routeDelete(route);
                nucleus.routeAdd(route);
            }
            this._tunnels.put(domain, tunnel);
            this.notifyAll();
        }

        public synchronized void remove(LocationMgrTunnel tunnel) {
            CellNucleus nucleus = tunnel.getNucleus();
            String domain = tunnel.getRemoteDomainName();
            if (this._tunnels.get(domain) == tunnel) {
                this._tunnels.remove(domain);
                nucleus.routeDelete(new CellRoute(domain, tunnel.getCellName(), 3));
                this.notifyAll();
            }
        }
    }
}

