/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.network.PingMessage;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellEventListener;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellLock;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellShell;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.nucleus.EventLogger;
import dmg.cells.nucleus.ExceptionEvent;
import dmg.cells.nucleus.KillEvent;
import dmg.cells.nucleus.LastMessageEvent;
import dmg.cells.nucleus.MessageEvent;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.Reply;
import dmg.cells.nucleus.SerializationException;
import dmg.cells.nucleus.UOID;
import dmg.util.Authorizable;
import dmg.util.AuthorizedArgs;
import dmg.util.AuthorizedString;
import dmg.util.CommandAclException;
import dmg.util.CommandException;
import dmg.util.CommandExitException;
import dmg.util.CommandPanicException;
import dmg.util.CommandSyntaxException;
import dmg.util.CommandThrowableException;
import dmg.util.Gate;
import dmg.util.Pinboard;
import dmg.util.command.Argument;
import dmg.util.command.Command;
import dmg.util.command.Option;
import dmg.util.logback.FilterShell;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.dcache.util.Args;
import org.dcache.util.Version;
import org.dcache.util.cli.CommandInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellAdapter
extends dmg.util.CommandInterpreter
implements Cell,
CellEventListener,
CellEndpoint {
    private static final Logger _log = LoggerFactory.getLogger(CellAdapter.class);
    private final CellVersion _version = new CellVersion(Version.of((Object)this));
    private static final ThreadLocal<CellMessage> CURRENT_MESSAGE = new ThreadLocal();
    private final CellNucleus _nucleus;
    private final Gate _readyGate = new Gate(false);
    private final Gate _startGate = new Gate(false);
    private final Args _args;
    private boolean _useInterpreter = true;
    private boolean _returnCommandException = true;
    private boolean _answerPing = true;
    private String _autoSetup;
    private String _definedSetup;
    private CellPath _aclPath = new CellPath("acm");
    private long _aclTimeout = 10000L;

    public CellAdapter(String cellName, String args, boolean startNow) {
        this(cellName, new Args((CharSequence)(args == null ? "" : args)), startNow);
    }

    public CellAdapter(String cellName, String cellType, String args, boolean startNow) {
        this(cellName, cellType, new Args((CharSequence)(args == null ? "" : args)), startNow);
    }

    public CellAdapter(String cellName, Args args, boolean startNow) {
        this(cellName, "Generic", args, startNow);
    }

    public CellAdapter(String cellName, String cellType, Args args, boolean startNow) {
        this._args = args;
        this._nucleus = new CellNucleus(this, cellName, cellType);
        this._autoSetup = cellName + "Setup";
        if (this._args.argc() > 0 && (this._definedSetup = this._args.argv(0)).length() > 1 && this._definedSetup.startsWith("!")) {
            this._definedSetup = this._definedSetup.substring(1);
            this._args.shift();
        } else {
            this._definedSetup = null;
        }
        if (this._args.hasOption("export") && (this._args.getOption("export").isEmpty() || Boolean.parseBoolean(this._args.getOption("export")))) {
            this.export();
        }
        if (this._args.hasOption("replyObject") && this._args.getOpt("replyObject").equals("false")) {
            this.setCommandExceptionEnabled(false);
        }
        this.addCommandListener(new FilterShell(this._nucleus.getLoggingThresholds()));
        this.addCommandListener(new CommandInterpreter.HelpCommands((CommandInterpreter)this));
        if (startNow) {
            this.start();
        }
    }

    public void start() {
        this.executeSetupContext();
        this._startGate.open();
    }

    public Serializable command(Args args) throws CommandException {
        if (args.argc() == 0) {
            return "";
        }
        if (args.argc() > 0 && args.argv(0).equals("xyzzy")) {
            return "Nothing happens.";
        }
        return super.command(args);
    }

    public void executeSetupContext() {
        if (this._autoSetup != null) {
            this.executeDomainContext(this._autoSetup);
        }
        this._autoSetup = null;
        if (this._definedSetup != null) {
            this.executeDomainContext(this._definedSetup);
        }
        this._definedSetup = null;
    }

    protected void executeDomainContext(String name) {
        if (name != null) {
            try (Reader in = this._nucleus.getDomainContextReader(name);){
                CellShell shell = new CellShell(this);
                shell.execute("context:" + name, in, new Args((CharSequence)""));
            }
            catch (FileNotFoundException e) {
            }
            catch (CommandExitException | IOException e) {
                _log.warn(e.getMessage());
            }
        }
    }

    public CellAdapter(String cellName) {
        this(cellName, "", true);
    }

    public CellAdapter(String cellName, String args) {
        this(cellName, args, true);
    }

    public void addCellEventListener(CellEventListener cel) {
        this._nucleus.addCellEventListener(cel);
    }

    public void addCellEventListener() {
        this._nucleus.addCellEventListener(this);
    }

    @Override
    public Args getArgs() {
        return this._args;
    }

    public void setCommandExceptionEnabled(boolean use) {
        this._returnCommandException = use;
    }

    public void useInterpreter(boolean use) {
        this._useInterpreter = use;
    }

    public void setAnswerPing(boolean ping) {
        this._answerPing = ping;
    }

    public CellNucleus getNucleus() {
        return this._nucleus;
    }

    public void initLoggingContext() {
        CDC.reset(this._nucleus);
    }

    protected void kill() {
        this._nucleus.kill();
    }

    public String getCellName() {
        return this._nucleus.getCellName();
    }

    public String getCellDomainName() {
        return this._nucleus.getCellDomainName();
    }

    public void export() {
        this._nucleus.export();
    }

    public void createPinboard(int size) {
        this._nucleus.setPinboard(new Pinboard(size <= 0 ? 200 : size));
    }

    public Object createNewCell(String className, String cellName, String[] argsClassNames, Object[] args) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, InvocationTargetException, IllegalAccessException, ClassCastException {
        return this._nucleus.createNewCell(className, cellName, argsClassNames, args);
    }

    @Override
    public Map<String, Object> getDomainContext() {
        return this._nucleus.getDomainContext();
    }

    public Reader getDomainContextReader(String contextName) throws FileNotFoundException {
        return this._nucleus.getDomainContextReader(contextName);
    }

    protected <T> Future<T> invokeOnMessageThread(Callable<T> task) {
        return this._nucleus.invokeOnMessageThread(task);
    }

    @Override
    public void sendMessage(CellMessage msg) throws SerializationException, NoRouteToCellException {
        this.getNucleus().sendMessage(msg, true, true);
    }

    @Override
    public void sendMessageWithRetryOnNoRouteToCell(CellMessage msg, CellMessageAnswerable callback, Executor executor, long timeout) throws SerializationException {
        RetryingCellMessageAnswerable retryingCallback = new RetryingCellMessageAnswerable(msg, callback, executor, timeout);
        this.sendMessage(msg, retryingCallback, executor, timeout);
    }

    @Override
    public void sendMessage(CellMessage msg, CellMessageAnswerable callback, Executor executor, long timeout) throws SerializationException {
        this.getNucleus().sendMessage(msg, true, true, callback, executor, timeout);
    }

    public static final CellMessage getThisMessage() {
        return CURRENT_MESSAGE.get();
    }

    public String toString() {
        return this._nucleus.getCellName();
    }

    public void getInfo(PrintWriter printWriter) {
        printWriter.println(" CellName  : " + this._nucleus.getCellName());
        printWriter.println(" CellClass : " + this.getClass().getName());
        printWriter.println(" Arguments : " + this._args);
    }

    @Override
    public CellVersion getCellVersion() {
        return this._version;
    }

    @Override
    public CellInfo getCellInfo() {
        return this._nucleus.getCellInfo();
    }

    public void messageArrived(CellMessage msg) {
        _log.info(" CellMessage From   : " + msg.getSourcePath());
        _log.info(" CellMessage To     : " + msg.getDestinationPath());
        _log.info(" CellMessage Object : " + msg.getMessageObject());
    }

    public void messageToForward(CellMessage msg) {
        msg.nextDestination();
        try {
            this._nucleus.sendMessage(msg, true, true);
        }
        catch (NoRouteToCellException nrtc) {
            _log.warn("CellAdapter : NoRouteToCell in messageToForward : " + nrtc);
        }
        catch (Exception eee) {
            _log.warn("CellAdapter : Exception in messageToForward : " + eee);
        }
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this._nucleus.loadClass(className);
    }

    public Serializable commandArrived(String str, CommandSyntaxException cse) {
        StringBuilder sb = new StringBuilder();
        sb.append("Syntax Error : ").append(cse.getMessage()).append("\n");
        String help = cse.getHelpText();
        if (help != null) {
            sb.append("Help : \n");
            sb.append(help);
        }
        return sb.toString();
    }

    protected void awaitStart() {
        this._startGate.check();
    }

    public void cleanUp() {
    }

    @Override
    public void cellCreated(CellEvent ce) {
    }

    @Override
    public void cellDied(CellEvent ce) {
    }

    @Override
    public void cellExported(CellEvent ce) {
    }

    @Override
    public void routeAdded(CellEvent ce) {
    }

    @Override
    public void routeDeleted(CellEvent ce) {
    }

    @Override
    public void prepareRemoval(KillEvent ce) {
        _log.info("CellAdapter : prepareRemoval : waiting for gate to open");
        this._startGate.check();
        this._readyGate.check();
        this.cleanUp();
        this.dumpPinboard();
        _log.info("CellAdapter : prepareRemoval : done");
    }

    void dumpPinboard() {
        Pinboard pinboard = this._nucleus.getPinboard();
        try {
            Map<String, Object> context = this.getDomainContext();
            String dumpDir = (String)context.get("dumpDirectory");
            if (dumpDir == null) {
                _log.info("Pinboard not dumped (dumpDirectory not sp.)");
                return;
            }
            File dir = new File(dumpDir);
            if (!dir.isDirectory()) {
                _log.info("Pinboard not dumped (dumpDirectory {} not found)", (Object)dumpDir);
                return;
            }
            if (pinboard == null) {
                _log.info("Pinboard not dumped (no pinboard defined)");
                return;
            }
            File dump = new File(dir, this.getCellDomainName() + "-" + this.getCellName() + "-" + Long.toHexString(System.currentTimeMillis()));
            pinboard.dump(dump);
        }
        catch (IOException e) {
            _log.error("Dumping pinboard failed : {}", (Object)e.toString());
        }
    }

    @Override
    public void exceptionArrived(ExceptionEvent ce) {
        _log.info(" exceptionArrived " + ce);
    }

    @Override
    public String getInfo() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.getInfo(printWriter);
        printWriter.flush();
        return stringWriter.getBuffer().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageArrived(MessageEvent me) {
        block39: {
            if (me instanceof LastMessageEvent) {
                _log.info("messageArrived : LastMessageEvent (opening gate)");
                this._readyGate.open();
            } else if (!this._startGate.isOpen()) {
                CellMessage msg = me.getMessage();
                if (!msg.isReply()) {
                    try {
                        NoRouteToCellException e = new NoRouteToCellException(msg.getUOID(), msg.getDestinationPath(), this.getCellName() + " is still initializing.");
                        msg.revertDirection();
                        msg.setMessageObject(e);
                        this._nucleus.sendMessage(msg, true, true);
                    }
                    catch (NoRouteToCellException e) {
                        _log.warn("PANIC : Problem returning answer : " + e);
                    }
                }
            } else {
                CellMessage msg = me.getMessage();
                Serializable obj = msg.getMessageObject();
                if (msg.isFinalDestination()) {
                    if (!msg.isReply() && msg.getLocalAge() > msg.getAdjustedTtl()) {
                        _log.warn("Discarding " + obj.getClass().getSimpleName() + " because its time to live has been exceeded.");
                        return;
                    }
                    if (this._useInterpreter && !msg.isReply() && (obj instanceof String || obj instanceof AuthorizedString)) {
                        Object o;
                        UOID uoid = msg.getUOID();
                        EventLogger.deliverBegin(msg);
                        try {
                            CURRENT_MESSAGE.set(msg);
                            o = this.executeLocalCommand(obj);
                            if (o == null) {
                                return;
                            }
                        }
                        catch (CommandThrowableException e) {
                            o = e.getCause();
                        }
                        catch (CommandException ce) {
                            o = ce;
                        }
                        finally {
                            EventLogger.deliverEnd(msg.getSession(), uoid);
                            CURRENT_MESSAGE.remove();
                        }
                        try {
                            msg.revertDirection();
                            if (o instanceof Reply) {
                                Reply reply = (Reply)o;
                                reply.deliver(this, msg);
                                break block39;
                            }
                            msg.setMessageObject((Serializable)o);
                            this._nucleus.sendMessage(msg, true, true);
                        }
                        catch (NoRouteToCellException e) {
                            _log.warn("PANIC : Problem returning answer : " + e);
                        }
                    } else if (obj instanceof PingMessage && this._answerPing) {
                        PingMessage ping = (PingMessage)obj;
                        if (ping.isWayBack()) {
                            this.messageArrived(msg);
                            return;
                        }
                        ping.setWayBack();
                        msg.revertDirection();
                        try {
                            this._nucleus.sendMessage(msg, true, true);
                        }
                        catch (NoRouteToCellException ee) {
                            _log.warn("Couldn't revert PingMessage : " + ee);
                        }
                    } else {
                        UOID uoid = msg.getUOID();
                        EventLogger.deliverBegin(msg);
                        try {
                            this.messageArrived(msg);
                        }
                        finally {
                            EventLogger.deliverEnd(msg.getSession(), uoid);
                        }
                    }
                } else if (obj instanceof PingMessage) {
                    msg.nextDestination();
                    try {
                        this._nucleus.sendMessage(msg, true, true);
                    }
                    catch (NoRouteToCellException ee) {
                        _log.warn("Couldn't forward PingMessage : " + ee);
                    }
                } else {
                    UOID uoid = msg.getUOID();
                    EventLogger.deliverBegin(msg);
                    try {
                        this.messageToForward(msg);
                    }
                    finally {
                        EventLogger.deliverEnd(msg.getSession(), uoid);
                    }
                }
            }
        }
    }

    private Serializable executeLocalCommand(Object command) throws CommandException {
        if (command instanceof Authorizable) {
            if (this._returnCommandException) {
                AuthorizedArgs args = new AuthorizedArgs((Authorizable)command);
                return this.command(args);
            }
            return this.autoCommand(command);
        }
        if (command instanceof String) {
            if (this._returnCommandException) {
                Args args = new Args((CharSequence)((String)command));
                return this.command(args);
            }
            return this.autoCommand(command);
        }
        throw new CommandPanicException("Illegal CommandClass detected", (Throwable)new Exception("PANIC"));
    }

    private Serializable autoCommand(Object command) {
        try {
            if (command instanceof String) {
                Args args = new Args((CharSequence)((String)command));
                return this.command(new Args((CharSequence)((String)command)));
            }
            if (command instanceof AuthorizedString) {
                AuthorizedArgs args = new AuthorizedArgs((AuthorizedString)command);
                return this.command(args);
            }
            return "Panic : internal server error 14345";
        }
        catch (CommandSyntaxException cse) {
            return this.commandArrived(command.toString(), cse);
        }
        catch (CommandExitException cee) {
            return "Sorry, can't exit";
        }
        catch (CommandThrowableException cte) {
            StringBuilder sb = new StringBuilder();
            sb.append(cte.getMessage()).append("\n");
            Throwable t = cte.getTargetException();
            sb.append(t.getClass().getName()).append(" : ").append(t.getMessage()).append("\n");
            return sb.toString();
        }
        catch (CommandPanicException cpe) {
            StringBuilder sb = new StringBuilder();
            sb.append("Panic : ").append(cpe.getMessage()).append("\n");
            Throwable t = cpe.getTargetException();
            sb.append(t.getClass().getName()).append(" : ").append(t.getMessage()).append("\n");
            return sb.toString();
        }
        catch (Exception e) {
            return "??? : " + e.toString();
        }
    }

    protected Serializable doExecute(CommandInterpreter.CommandEntry entry, Args args, String[] acls) throws CommandException {
        if (args instanceof Authorizable) {
            this.checkAclPermission((Authorizable)args, (Object)args, acls);
        }
        return super.doExecute(entry, args, acls);
    }

    protected void checkAclPermission(Authorizable auth, Object command, String[] acls) throws CommandException {
        String user = auth.getAuthorizedPrincipal();
        if (user.equals("admin") || acls.length == 0) {
            return;
        }
        CommandAclException recentException = null;
        for (String acl : acls) {
            try {
                this.checkAclPermission(user, command, acl);
                return;
            }
            catch (CommandAclException ce) {
                recentException = ce;
            }
        }
        throw recentException;
    }

    protected void checkAclPermission(String user, Object command, String acl) throws CommandException {
        CellMessage reply;
        Object[] request = new Object[]{"request", "<nobody>", "check-permission", user, acl};
        try {
            reply = this._nucleus.sendAndWait(new CellMessage(this._aclPath, (Serializable)request), this._aclTimeout);
            if (reply == null) {
                throw new CommandException("Error in acl handling : Acl Request timed out (" + this._aclPath + ")");
            }
        }
        catch (NoRouteToCellException | InterruptedException | ExecutionException e) {
            throw new CommandException("Error in acl handling: " + e.getMessage(), (Throwable)e);
        }
        Serializable r = reply.getMessageObject();
        if (r == null || !(r instanceof Object[]) || ((Object[])r).length < 6 || !(((Object[])r)[5] instanceof Boolean)) {
            throw new CommandException("Error in acl handling: illegal reply arrived");
        }
        if (!((Boolean)((Object[])r)[5]).booleanValue()) {
            throw new CommandAclException(user, acl);
        }
    }

    private class RetryingCellMessageAnswerable
    implements CellMessageAnswerable,
    Runnable {
        private final long deadline;
        private final CellMessageAnswerable callback;
        private final CellMessage msg;
        private final Executor executor;

        public RetryingCellMessageAnswerable(CellMessage msg, CellMessageAnswerable callback, Executor executor, long timeout) {
            this.callback = callback;
            this.msg = msg;
            this.executor = executor;
            this.deadline = System.currentTimeMillis() + timeout;
        }

        @Override
        public void answerArrived(CellMessage request, CellMessage answer) {
            this.callback.answerArrived(request, answer);
        }

        @Override
        public void exceptionArrived(CellMessage request, Exception exception) {
            if (!(exception instanceof NoRouteToCellException)) {
                this.callback.exceptionArrived(request, exception);
            } else if (this.deadline > System.currentTimeMillis()) {
                CellAdapter.this._nucleus.invokeLater(this);
            } else {
                this.callback.answerTimedOut(request);
            }
        }

        @Override
        public void answerTimedOut(CellMessage request) {
            this.callback.answerTimedOut(request);
        }

        @Override
        public void run() {
            long timeout = this.deadline - System.currentTimeMillis();
            if (timeout > 0L) {
                CellAdapter.this.sendMessage(this.msg, this, this.executor, timeout);
            } else {
                this.callback.answerTimedOut(this.msg);
            }
        }
    }

    @Command(name="dump pinboard", hint="write pinboard to file", description="Writes the pinboard log to FILE on the local file system of the service.")
    public class DumpPinboardCommand
    implements Callable<String> {
        @Argument(metaVar="file")
        File file;

        @Override
        public String call() throws IOException {
            Pinboard pinboard = CellAdapter.this._nucleus.getPinboard();
            if (pinboard == null) {
                return "No pinboard defined.";
            }
            pinboard.dump(this.file);
            return "Pinboard dumped to " + this.file;
        }
    }

    @Command(name="show pinboard", hint="display the most recent pinboard messages", description="The pinboard always stores the most recent log messages.  It has a fixed capacity: once full appending a new message will eject the oldest stored message.  See also the 'log set' command.")
    public class ShowPinboardCommand
    implements Callable<String> {
        @Argument(required=false, metaVar="lines", usage="How many pinboard entries to display.")
        int lines = 20;

        @Override
        public String call() {
            Pinboard pinboard = CellAdapter.this._nucleus.getPinboard();
            if (pinboard == null) {
                return "No pinboard defined";
            }
            StringBuilder sb = new StringBuilder();
            pinboard.dump(sb, this.lines);
            return sb.toString();
        }
    }

    @Command(name="info")
    public class InfoCommand
    implements Callable<String> {
        @Option(name="a", usage="Display content of unanswered message requests.")
        boolean full;
        @Option(name="l", usage="Display unanswered message requests.")
        boolean lng;

        @Override
        public String call() {
            if (this.lng || this.full) {
                StringBuilder sb = new StringBuilder();
                sb.append(CellAdapter.this.getInfo()).append("\n");
                Map<UOID, CellLock> map = CellAdapter.this._nucleus.getWaitQueue();
                if (!map.isEmpty()) {
                    sb.append("\nWe are waiting for the following messages\n");
                }
                for (Map.Entry<UOID, CellLock> entry : map.entrySet()) {
                    UOID key = entry.getKey();
                    CellLock lock = entry.getValue();
                    sb.append(((Object)key).toString()).append(" r=");
                    long res = lock.getTimeout() - System.currentTimeMillis();
                    sb.append(res / 1000L).append(" sec;");
                    CellMessage msg = lock.getMessage();
                    if (msg == null) {
                        sb.append("msg=none");
                    } else {
                        Serializable obj = msg.getMessageObject();
                        if (obj != null) {
                            sb.append("msg=").append(obj.getClass().getName());
                            if (this.full) {
                                sb.append("/").append(obj.toString());
                            }
                        }
                    }
                    sb.append("\n");
                }
                return sb.toString();
            }
            return CellAdapter.this.getInfo();
        }
    }

    @Command(name="xgetcellinfo")
    public class GetCellInfoCommand
    implements Callable<CellInfo> {
        @Override
        public CellInfo call() {
            return CellAdapter.this.getCellInfo();
        }
    }
}

