/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import com.google.common.base.Preconditions;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import java.util.concurrent.Executor;

public class CellLock {
    private final CellMessageAnswerable _callback;
    private final long _timeout;
    private final CellMessage _message;
    private final CDC _cdc = new CDC();
    private final Executor _executor;

    public CellLock(CellMessage msg, CellMessageAnswerable callback, Executor executor, long timeout) {
        this._callback = (CellMessageAnswerable)Preconditions.checkNotNull((Object)callback);
        this._executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this._timeout = System.currentTimeMillis() + timeout;
        this._message = msg;
    }

    public CellMessageAnswerable getCallback() {
        return this._callback;
    }

    public CellMessage getMessage() {
        return this._message;
    }

    public Executor getExecutor() {
        return this._executor;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public CDC getCdc() {
        return this._cdc;
    }
}

